/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.annotation.Immutable;
import com.amazonaws.util.NameValuePair;
import java.io.Serializable;

@Immutable
class BasicNameValuePair
implements NameValuePair,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final int HASH_SEED = 17;
    public static final int HASH_OFFSET = 37;
    private final String name;
    private final String value;

    BasicNameValuePair(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        this.name = string;
        this.value = string2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return this.name;
        }
        int n = this.name.length() + 1 + this.value.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.append(this.name);
        stringBuilder.append("=");
        stringBuilder.append(this.value);
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof NameValuePair) {
            BasicNameValuePair basicNameValuePair = (BasicNameValuePair)object;
            return this.name.equals(basicNameValuePair.name) && BasicNameValuePair.equals(this.value, basicNameValuePair.value);
        }
        return false;
    }

    private static boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public int hashCode() {
        int n = 17;
        n = BasicNameValuePair.hashCode(n, this.name);
        n = BasicNameValuePair.hashCode(n, this.value);
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static int hashCode(int n, Object object) {
        return BasicNameValuePair.hashCode(n, object != null ? object.hashCode() : 0);
    }

    private static int hashCode(int n, int n2) {
        return n * 37 + n2;
    }
}

