/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.util.Codec;
import com.amazonaws.util.CodecUtils;

class Base64Codec
implements Codec {
    private static final int OFFSET_OF_a = 71;
    private static final int OFFSET_OF_0 = -4;
    private static final int OFFSET_OF_PLUS = -19;
    private static final int OFFSET_OF_SLASH = -16;
    private static final int MASK_2BITS = 3;
    private static final int MASK_4BITS = 15;
    private static final int MASK_6BITS = 63;
    private static final byte PAD = 61;
    private final byte[] alphabets;

    Base64Codec() {
        this.alphabets = CodecUtils.toBytesDirect("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
    }

    protected Base64Codec(byte[] byArray) {
        this.alphabets = byArray;
    }

    @Override
    public byte[] encode(byte[] byArray) {
        int n = byArray.length / 3;
        int n2 = byArray.length % 3;
        if (n2 == 0) {
            byte[] byArray2 = new byte[n * 4];
            int n3 = 0;
            int n4 = 0;
            while (n3 < byArray.length) {
                this.encode3bytes(byArray, n3, byArray2, n4);
                n3 += 3;
                n4 += 4;
            }
            return byArray2;
        }
        byte[] byArray3 = new byte[(n + 1) * 4];
        int n5 = 0;
        int n6 = 0;
        while (n5 < byArray.length - n2) {
            this.encode3bytes(byArray, n5, byArray3, n6);
            n5 += 3;
            n6 += 4;
        }
        switch (n2) {
            case 1: {
                this.encode1byte(byArray, n5, byArray3, n6);
                break;
            }
            case 2: {
                this.encode2bytes(byArray, n5, byArray3, n6);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return byArray3;
    }

    void encode3bytes(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = n2++;
        byte by = byArray[n++];
        byArray2[n3] = this.alphabets[by >>> 2 & 0x3F];
        int n4 = n2++;
        int n5 = (by & 3) << 4;
        by = byArray[n++];
        byArray2[n4] = this.alphabets[n5 | by >>> 4 & 0xF];
        int n6 = n2++;
        int n7 = (by & 0xF) << 2;
        by = byArray[n];
        byArray2[n6] = this.alphabets[n7 | by >>> 6 & 3];
        byArray2[n2] = this.alphabets[by & 0x3F];
    }

    void encode2bytes(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = n2++;
        byte by = byArray[n++];
        byArray2[n3] = this.alphabets[by >>> 2 & 0x3F];
        int n4 = n2++;
        int n5 = (by & 3) << 4;
        by = byArray[n];
        byArray2[n4] = this.alphabets[n5 | by >>> 4 & 0xF];
        byArray2[n2++] = this.alphabets[(by & 0xF) << 2];
        byArray2[n2] = 61;
    }

    void encode1byte(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = n2++;
        byte by = byArray[n];
        byArray2[n3] = this.alphabets[by >>> 2 & 0x3F];
        byArray2[n2++] = this.alphabets[(by & 3) << 4];
        byArray2[n2++] = 61;
        byArray2[n2] = 61;
    }

    void decode4bytes(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = 0;
        int n4 = n2++;
        int n5 = n++;
        n3 = this.pos(byArray[n++]);
        byArray2[n4] = (byte)(this.pos(byArray[n5]) << 2 | n3 >>> 4 & 3);
        int n6 = n2++;
        int n7 = (n3 & 0xF) << 4;
        n3 = this.pos(byArray[n++]);
        byArray2[n6] = (byte)(n7 | n3 >>> 2 & 0xF);
        byArray2[n2] = (byte)((n3 & 3) << 6 | this.pos(byArray[n]));
    }

    void decode1to3bytes(int n, byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4 = 0;
        int n5 = n3++;
        int n6 = n2++;
        n4 = this.pos(byArray[n2++]);
        byArray2[n5] = (byte)(this.pos(byArray[n6]) << 2 | n4 >>> 4 & 3);
        if (n == 1) {
            CodecUtils.sanityCheckLastPos(n4, 15);
            return;
        }
        int n7 = n3++;
        int n8 = (n4 & 0xF) << 4;
        n4 = this.pos(byArray[n2++]);
        byArray2[n7] = (byte)(n8 | n4 >>> 2 & 0xF);
        if (n == 2) {
            CodecUtils.sanityCheckLastPos(n4, 3);
            return;
        }
        byArray2[n3] = (byte)((n4 & 3) << 6 | this.pos(byArray[n2]));
    }

    @Override
    public byte[] decode(byte[] byArray, int n) {
        int n2;
        int n3;
        if (n % 4 != 0) {
            throw new IllegalArgumentException("Input is expected to be encoded in multiple of 4 bytes but found: " + n);
        }
        int n4 = 0;
        for (int i = n - 1; n4 < 2 && i > -1 && byArray[i] == 61; --i, ++n4) {
        }
        switch (n4) {
            case 0: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
            case 2: {
                n3 = 1;
                break;
            }
            default: {
                throw new Error("Impossible");
            }
        }
        byte[] byArray2 = new byte[n / 4 * 3 - (3 - n3)];
        int n5 = 0;
        for (n2 = 0; n2 < byArray2.length - n3 % 3; n2 += 3) {
            this.decode4bytes(byArray, n5, byArray2, n2);
            n5 += 4;
        }
        if (n3 < 3) {
            this.decode1to3bytes(n3, byArray, n5, byArray2, n2);
        }
        return byArray2;
    }

    protected int pos(byte by) {
        byte by2 = LazyHolder.DECODED[by];
        if (by2 > -1) {
            return by2;
        }
        throw new IllegalArgumentException("Invalid base 64 character: '" + (char)by + "'");
    }

    private static class LazyHolder {
        private static final byte[] DECODED = LazyHolder.decodeTable();

        private LazyHolder() {
        }

        private static byte[] decodeTable() {
            byte[] byArray = new byte[123];
            for (int i = 0; i <= 122; ++i) {
                byArray[i] = i >= 65 && i <= 90 ? (int)(i - 65) : (i >= 48 && i <= 57 ? (int)(i - -4) : (i == 43 ? (int)(i - -19) : (i == 47 ? (int)(i - -16) : (i >= 97 && i <= 122 ? (int)(i - 71) : -1))));
            }
            return byArray;
        }
    }
}

