/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.log.InternalLogApi;
import com.amazonaws.log.InternalLogFactory;
import com.amazonaws.util.Base64Codec;
import com.amazonaws.util.CodecUtils;
import java.util.HashMap;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;

public final class Base64
extends Enum<Base64> {
    private static final InternalLogApi LOG;
    private static final Base64Codec codec;
    private static final boolean isJaxbAvailable;
    private static final /* synthetic */ Base64[] $VALUES;

    public static Base64[] values() {
        return (Base64[])$VALUES.clone();
    }

    public static Base64 valueOf(String string) {
        return Enum.valueOf(Base64.class, string);
    }

    public static String encodeAsString(byte ... byArray) {
        if (byArray == null) {
            return null;
        }
        if (isJaxbAvailable) {
            try {
                return DatatypeConverter.printBase64Binary(byArray);
            }
            catch (NullPointerException nullPointerException) {
                LOG.debug("Recovering from JAXB bug: https://netbeans.org/bugzilla/show_bug.cgi?id=224923", nullPointerException);
            }
        }
        return byArray.length == 0 ? "" : CodecUtils.toStringDirect(codec.encode(byArray));
    }

    public static byte[] encode(byte[] byArray) {
        return byArray == null || byArray.length == 0 ? byArray : codec.encode(byArray);
    }

    public static byte[] decode(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[string.length()];
        int n = CodecUtils.sanitize(string, byArray);
        return codec.decode(byArray, n);
    }

    public static byte[] decode(byte[] byArray) {
        return byArray == null || byArray.length == 0 ? byArray : codec.decode(byArray, byArray.length);
    }

    static {
        boolean bl;
        $VALUES = new Base64[0];
        LOG = InternalLogFactory.getLog(Base64.class);
        codec = new Base64Codec();
        try {
            Class.forName("javax.xml.bind.DatatypeConverter");
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("org.apache.ws.jaxme.impl.JAXBContextImpl", "Apache JaxMe");
            try {
                String string = JAXBContext.newInstance(new Class[0]).getClass().getName();
                if (hashMap.containsKey(string)) {
                    LOG.warn("A JAXB implementation known to produce base64 encodings that are inconsistent with the reference implementation has been detected. The results of the encodeAsString() method may be incorrect. Implementation: " + (String)hashMap.get(string));
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                bl = false;
            }
            catch (Exception exception) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        } else {
            LOG.warn("JAXB is unavailable. Will fallback to SDK implementation which may be less performant.If you are using Java 9+, you will need to include javax.xml.bind:jaxb-api as a dependency.");
        }
        isJaxbAvailable = bl;
    }
}

