/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.ValidationUtils;

public class PathMarshallers {
    public static final PathMarshaller NON_GREEDY = new NonGreedyPathMarshaller();
    public static final PathMarshaller GREEDY = new GreedyPathMarshaller();
    public static final PathMarshaller IDEMPOTENCY = new IdempotencyPathMarshaller();

    private static String trimLeadingSlash(String string) {
        if (string.startsWith("/")) {
            return string.replaceFirst("/", "");
        }
        return string;
    }

    private static class IdempotencyPathMarshaller
    implements PathMarshaller {
        private IdempotencyPathMarshaller() {
        }

        @Override
        public String marshall(String string, String string2, String string3) {
            if (string3 != null && string3.isEmpty()) {
                throw new IllegalArgumentException(string2 + " must not be empty. If not set a value will be auto generated");
            }
            return string.replace(String.format("{%s}", string2), SdkHttpUtils.urlEncode(IdempotentUtils.resolveString(string3), false));
        }

        @Override
        public String marshall(String string, String string2, Integer n) {
            throw new UnsupportedOperationException("Integer idempotency tokens not yet supported");
        }

        @Override
        public String marshall(String string, String string2, Long l) {
            throw new UnsupportedOperationException("Long idempotency tokens not yet supported");
        }
    }

    private static class GreedyPathMarshaller
    implements PathMarshaller {
        private GreedyPathMarshaller() {
        }

        @Override
        public String marshall(String string, String string2, String string3) {
            ValidationUtils.assertStringNotEmpty(string3, string2);
            return string.replace(String.format("{%s+}", string2), PathMarshallers.trimLeadingSlash(string3));
        }

        @Override
        public String marshall(String string, String string2, Integer n) {
            ValidationUtils.assertNotNull(n, string2);
            return this.marshall(string, string2, StringUtils.fromInteger(n));
        }

        @Override
        public String marshall(String string, String string2, Long l) {
            ValidationUtils.assertNotNull(l, string2);
            return this.marshall(string, string2, StringUtils.fromLong(l));
        }
    }

    private static class NonGreedyPathMarshaller
    implements PathMarshaller {
        private NonGreedyPathMarshaller() {
        }

        @Override
        public String marshall(String string, String string2, String string3) {
            ValidationUtils.assertStringNotEmpty(string3, string2);
            return string.replace(String.format("{%s}", string2), SdkHttpUtils.urlEncode(string3, false));
        }

        @Override
        public String marshall(String string, String string2, Integer n) {
            ValidationUtils.assertNotNull(n, string2);
            return this.marshall(string, string2, StringUtils.fromInteger(n));
        }

        @Override
        public String marshall(String string, String string2, Long l) {
            ValidationUtils.assertNotNull(l, string2);
            return this.marshall(string, string2, StringUtils.fromLong(l));
        }
    }

    public static interface PathMarshaller {
        public String marshall(String var1, String var2, String var3);

        public String marshall(String var1, String var2, Integer var3);

        public String marshall(String var1, String var2, Long var3);
    }
}

