/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkProtectedApi;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import java.lang.reflect.Constructor;
import javax.xml.xpath.XPath;
import org.w3c.dom.Node;

@SdkProtectedApi
public class LegacyErrorUnmarshaller
implements Unmarshaller<AmazonServiceException, Node> {
    private final Class<? extends AmazonServiceException> exceptionClass;

    public LegacyErrorUnmarshaller() {
        this(AmazonServiceException.class);
    }

    public LegacyErrorUnmarshaller(Class<? extends AmazonServiceException> clazz) {
        this.exceptionClass = clazz;
    }

    @Override
    public AmazonServiceException unmarshall(Node node) throws Exception {
        XPath xPath = XpathUtils.xpath();
        String string = this.parseErrorCode(node, xPath);
        String string2 = XpathUtils.asString("Response/Errors/Error/Message", node, xPath);
        String string3 = XpathUtils.asString("Response/RequestID", node, xPath);
        String string4 = XpathUtils.asString("Response/Errors/Error/Type", node, xPath);
        Constructor<? extends AmazonServiceException> constructor = this.exceptionClass.getConstructor(String.class);
        AmazonServiceException amazonServiceException = constructor.newInstance(string2);
        amazonServiceException.setErrorCode(string);
        amazonServiceException.setRequestId(string3);
        if (string4 == null) {
            amazonServiceException.setErrorType(AmazonServiceException.ErrorType.Unknown);
        } else if (string4.equalsIgnoreCase("server")) {
            amazonServiceException.setErrorType(AmazonServiceException.ErrorType.Service);
        } else if (string4.equalsIgnoreCase("client")) {
            amazonServiceException.setErrorType(AmazonServiceException.ErrorType.Client);
        }
        return amazonServiceException;
    }

    public String parseErrorCode(Node node) throws Exception {
        return XpathUtils.asString("Response/Errors/Error/Code", node);
    }

    public String parseErrorCode(Node node, XPath xPath) throws Exception {
        return XpathUtils.asString("Response/Errors/Error/Code", node, xPath);
    }

    public String getErrorPropertyPath(String string) {
        return "Response/Errors/Error/" + string;
    }
}

