/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkThreadLocalsRegistry;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.util.BinaryUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Callable;

public class UploadPartCallable
implements Callable<PartETag> {
    private static final int MAX_SKIPS = 100;
    private static final ThreadLocal<MessageDigest> MD5_DIGEST = SdkThreadLocalsRegistry.register(new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SdkClientException("Unable to get a digest instance for MD5!", noSuchAlgorithmException);
            }
        }
    });
    private final AmazonS3 s3;
    private final UploadPartRequest request;
    private final boolean calculateMd5;

    public UploadPartCallable(AmazonS3 amazonS3, UploadPartRequest uploadPartRequest) {
        this(amazonS3, uploadPartRequest, false);
    }

    public UploadPartCallable(AmazonS3 amazonS3, UploadPartRequest uploadPartRequest, boolean bl) {
        this.s3 = amazonS3;
        this.request = uploadPartRequest;
        this.calculateMd5 = bl;
    }

    @Override
    public PartETag call() throws Exception {
        if (this.calculateMd5) {
            this.request.withMD5Digest(this.computedMd5());
        }
        PartETag partETag = this.s3.uploadPart(this.request).getPartETag();
        return partETag;
    }

    private String computedMd5() {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.request.getFile());
            this.skipBytes(fileInputStream, this.request.getFileOffset());
            String string = BinaryUtils.toBase64(UploadPartCallable.computeMd5Bytes(fileInputStream, this.request.getPartSize()));
            return string;
        }
        catch (IOException iOException) {
            throw new SdkClientException(iOException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static byte[] computeMd5Bytes(InputStream inputStream2, long l) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        MessageDigest messageDigest = MD5_DIGEST.get();
        messageDigest.reset();
        while (l > 0L && (n = inputStream2.read(byArray)) != -1) {
            int n2 = (int)Math.min(l, (long)n);
            messageDigest.update(byArray, 0, n2);
            l -= (long)n2;
        }
        return messageDigest.digest();
    }

    private void skipBytes(FileInputStream fileInputStream, long l) throws IOException {
        long l2 = 0L;
        for (int i = 0; i < 100 && l2 < l; l2 += fileInputStream.skip(l - l2), ++i) {
        }
        if (l2 != l) {
            throw new SdkClientException(String.format("Unable to skip to offset %d in file %s after %d attempts", l, this.request.getFile().getAbsolutePath(), 100));
        }
    }
}

