/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Encryption;
import com.amazonaws.services.s3.AmazonS3EncryptionV2;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.transfer.PauseStatus;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferManagerConfiguration;
import com.amazonaws.util.ValidationUtils;
import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransferManagerUtils {
    private static final Log log = LogFactory.getLog(TransferManagerUtils.class);

    public static ThreadPoolExecutor createDefaultExecutorService() {
        ThreadFactory threadFactory2 = new ThreadFactory(){
            private int threadCount = 1;

            @Override
            public Thread newThread(Runnable runnable2) {
                Thread thread2 = new Thread(runnable2);
                thread2.setName("s3-transfer-manager-worker-" + this.threadCount++);
                return thread2;
            }
        };
        return (ThreadPoolExecutor)Executors.newFixedThreadPool(10, threadFactory2);
    }

    public static boolean isUploadParallelizable(PutObjectRequest putObjectRequest, boolean bl) {
        if (bl) {
            return false;
        }
        return TransferManagerUtils.getRequestFile(putObjectRequest) != null;
    }

    public static long getContentLength(PutObjectRequest putObjectRequest) {
        File file = TransferManagerUtils.getRequestFile(putObjectRequest);
        if (file != null) {
            return file.length();
        }
        if (putObjectRequest.getInputStream() != null && putObjectRequest.getMetadata().getContentLength() > 0L) {
            return putObjectRequest.getMetadata().getContentLength();
        }
        return -1L;
    }

    public static long calculateOptimalPartSize(PutObjectRequest putObjectRequest, TransferManagerConfiguration transferManagerConfiguration) {
        double d = TransferManagerUtils.getContentLength(putObjectRequest);
        double d2 = d / 10000.0;
        d2 = Math.ceil(d2);
        return (long)Math.max(d2, (double)transferManagerConfiguration.getMinimumUploadPartSize());
    }

    public static boolean shouldUseMultipartUpload(PutObjectRequest putObjectRequest, TransferManagerConfiguration transferManagerConfiguration) {
        long l = TransferManagerUtils.getContentLength(putObjectRequest);
        return l > transferManagerConfiguration.getMultipartUploadThreshold();
    }

    public static File getRequestFile(PutObjectRequest putObjectRequest) {
        if (putObjectRequest.getFile() != null) {
            return putObjectRequest.getFile();
        }
        return null;
    }

    public static long calculateOptimalPartSizeForCopy(CopyObjectRequest copyObjectRequest, TransferManagerConfiguration transferManagerConfiguration, long l) {
        double d = (double)l / 10000.0;
        d = Math.ceil(d);
        return (long)Math.max(d, (double)transferManagerConfiguration.getMultipartCopyPartSize());
    }

    public static PauseStatus determinePauseStatus(Transfer.TransferState transferState, boolean bl) {
        if (bl) {
            if (transferState == Transfer.TransferState.Waiting) {
                return PauseStatus.CANCELLED_BEFORE_START;
            }
            if (transferState == Transfer.TransferState.InProgress) {
                return PauseStatus.CANCELLED;
            }
        }
        if (transferState == Transfer.TransferState.Waiting) {
            return PauseStatus.NOT_STARTED;
        }
        return PauseStatus.NO_EFFECT;
    }

    public static boolean isDownloadParallelizable(AmazonS3 amazonS3, GetObjectRequest getObjectRequest, Integer n) {
        ValidationUtils.assertNotNull(amazonS3, "S3 client");
        ValidationUtils.assertNotNull(getObjectRequest, "GetObjectRequest");
        return !(amazonS3 instanceof AmazonS3Encryption) && !(amazonS3 instanceof AmazonS3EncryptionV2) && getObjectRequest.getRange() == null && getObjectRequest.getPartNumber() == null && n != null;
    }

    public static Long getContentLengthFromContentRange(ObjectMetadata objectMetadata) {
        ValidationUtils.assertNotNull(objectMetadata, "Object metadata");
        String string = (String)objectMetadata.getRawMetadataValue("Content-Range");
        if (string != null) {
            try {
                String[] stringArray = string.split("[ -/]+");
                return Long.parseLong(stringArray[3]);
            }
            catch (Exception exception) {
                log.info(String.format("Error parsing 'Content-Range' header value: %s. So returning null value for content length", string), exception);
            }
        }
        return null;
    }
}

