/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.event.ProgressEventType;
import com.amazonaws.event.ProgressListenerChain;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferProgress;
import com.amazonaws.services.s3.transfer.internal.AbstractTransfer;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class MultipleFileTransfer<T extends Transfer>
extends AbstractTransfer {
    protected final Collection<? extends T> subTransfers;
    private AtomicBoolean subTransferStarted = new AtomicBoolean(false);

    MultipleFileTransfer(String string, TransferProgress transferProgress, ProgressListenerChain progressListenerChain, Collection<? extends T> collection) {
        super(string, transferProgress, progressListenerChain);
        this.subTransfers = collection;
    }

    public void collateFinalState() {
        boolean bl = false;
        for (Transfer transfer : this.subTransfers) {
            if (transfer.getState() == Transfer.TransferState.Failed) {
                this.setState(Transfer.TransferState.Failed);
                return;
            }
            if (transfer.getState() != Transfer.TransferState.Canceled) continue;
            bl = true;
        }
        if (bl) {
            this.setState(Transfer.TransferState.Canceled);
        } else {
            this.setState(Transfer.TransferState.Completed);
        }
    }

    @Override
    public void setState(Transfer.TransferState transferState) {
        super.setState(transferState);
        switch (transferState) {
            case Waiting: {
                this.fireProgressEvent(ProgressEventType.TRANSFER_PREPARING_EVENT);
                break;
            }
            case InProgress: {
                if (!this.subTransferStarted.compareAndSet(false, true)) break;
                this.fireProgressEvent(ProgressEventType.TRANSFER_STARTED_EVENT);
                break;
            }
            case Completed: {
                this.fireProgressEvent(ProgressEventType.TRANSFER_COMPLETED_EVENT);
                break;
            }
            case Canceled: {
                this.fireProgressEvent(ProgressEventType.TRANSFER_CANCELED_EVENT);
                break;
            }
            case Failed: {
                this.fireProgressEvent(ProgressEventType.TRANSFER_FAILED_EVENT);
                break;
            }
        }
    }
}

