/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.util.IOUtils;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
public class DownloadS3ObjectCallable
implements Callable<Long> {
    private static final Log LOG = LogFactory.getLog(DownloadS3ObjectCallable.class);
    private static final int BUFFER_SIZE = 0x200000;
    private final Callable<S3Object> serviceCall;
    private final File destinationFile;
    private final long position;

    public DownloadS3ObjectCallable(Callable<S3Object> callable, File file, long l) {
        this.serviceCall = callable;
        this.destinationFile = file;
        this.position = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long call() throws Exception {
        long l;
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.destinationFile, "rw");
        FileChannel fileChannel = randomAccessFile.getChannel();
        fileChannel.position(this.position);
        S3ObjectInputStream s3ObjectInputStream = null;
        try {
            int n;
            S3Object s3Object = this.serviceCall.call();
            s3ObjectInputStream = s3Object.getObjectContent();
            byte[] byArray = new byte[0x200000];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            while ((n = s3ObjectInputStream.read(byArray)) > -1) {
                byteBuffer.limit(n);
                while (byteBuffer.hasRemaining()) {
                    fileChannel.write(byteBuffer);
                }
                byteBuffer.clear();
            }
            l = fileChannel.position();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(s3ObjectInputStream, LOG);
            IOUtils.closeQuietly(randomAccessFile, LOG);
            IOUtils.closeQuietly(fileChannel, LOG);
            throw throwable;
        }
        IOUtils.closeQuietly(s3ObjectInputStream, LOG);
        IOUtils.closeQuietly(randomAccessFile, LOG);
        IOUtils.closeQuietly(fileChannel, LOG);
        return l;
    }
}

