/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer;

import com.amazonaws.AmazonClientException;
import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.internal.FileLocks;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.transfer.DownloadTaskImpl;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.exception.FileLockException;
import com.amazonaws.services.s3.transfer.internal.AbstractDownloadCallable;
import com.amazonaws.services.s3.transfer.internal.CompleteMultipartDownload;
import com.amazonaws.services.s3.transfer.internal.DownloadImpl;
import com.amazonaws.services.s3.transfer.internal.DownloadMonitor;
import com.amazonaws.services.s3.transfer.internal.DownloadS3ObjectCallable;
import com.amazonaws.util.IOUtils;
import java.io.File;
import java.io.RandomAccessFile;
import java.net.SocketException;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.ssl.SSLProtocolException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
final class DownloadCallable
extends AbstractDownloadCallable {
    private static final Log LOG = LogFactory.getLog(DownloadCallable.class);
    private final AmazonS3 s3;
    private final GetObjectRequest req;
    private final boolean resumeExistingDownload;
    private final DownloadImpl download;
    private final long origStartingByte;
    private Integer lastFullyMergedPartNumber;
    private Long lastFullyMergedPartPosition;
    private final boolean resumeOnRetry;
    private long expectedFileLength;
    private static boolean testing;

    DownloadCallable(AmazonS3 amazonS3, CountDownLatch countDownLatch, GetObjectRequest getObjectRequest, boolean bl, DownloadImpl downloadImpl, File file, long l, long l2, long l3, ScheduledExecutorService scheduledExecutorService, ExecutorService executorService, Integer n, boolean bl2, boolean bl3) {
        super(DownloadCallable.constructCallableConfig(executorService, file, countDownLatch, downloadImpl, bl2, scheduledExecutorService, l3));
        if (amazonS3 == null || getObjectRequest == null || downloadImpl == null) {
            throw new IllegalArgumentException();
        }
        this.s3 = amazonS3;
        this.req = getObjectRequest;
        this.resumeExistingDownload = bl;
        this.download = downloadImpl;
        this.origStartingByte = l;
        this.expectedFileLength = l2;
        this.lastFullyMergedPartNumber = n;
        this.resumeOnRetry = bl3;
    }

    DownloadCallable withLastFullyMergedPartPosition(Long l) {
        this.lastFullyMergedPartPosition = l;
        return this;
    }

    @Override
    protected void downloadAsSingleObject() {
        S3Object s3Object = this.retryableDownloadS3ObjectToFile(this.dstfile, new DownloadTaskImpl(this.s3, this.download, this.req));
        this.updateDownloadStatus(s3Object);
    }

    @Override
    protected void downloadInParallel() throws Exception {
        this.downloadInParallel(ServiceUtils.getPartCount(this.req, this.s3));
    }

    @Override
    protected void setState(Transfer.TransferState transferState) {
        this.download.setState(transferState);
    }

    private void updateDownloadStatus(S3Object s3Object) {
        if (s3Object == null) {
            this.download.setState(Transfer.TransferState.Canceled);
            this.download.setMonitor(new DownloadMonitor(this.download, null));
        } else {
            this.download.setState(Transfer.TransferState.Completed);
        }
    }

    private void downloadInParallel(int n) throws Exception {
        if (this.lastFullyMergedPartNumber == null) {
            this.lastFullyMergedPartNumber = 0;
        }
        if (this.lastFullyMergedPartPosition == null) {
            this.lastFullyMergedPartPosition = 0L;
        }
        long l = 0L;
        long l2 = this.lastFullyMergedPartPosition;
        ServiceUtils.createParentDirectoryIfNecessary(this.dstfile);
        this.truncateDestinationFileIfNecessary();
        if (!FileLocks.lock(this.dstfile)) {
            throw new FileLockException("Fail to lock " + this.dstfile);
        }
        try {
            for (int i = this.lastFullyMergedPartNumber + 1; i <= n; ++i) {
                l2 += l;
                GetObjectRequest getObjectRequest = (GetObjectRequest)new GetObjectRequest(this.req.getBucketName(), this.req.getKey(), this.req.getVersionId()).withUnmodifiedSinceConstraint(this.req.getUnmodifiedSinceConstraint()).withModifiedSinceConstraint(this.req.getModifiedSinceConstraint()).withResponseHeaders(this.req.getResponseHeaders()).withSSECustomerKey(this.req.getSSECustomerKey()).withGeneralProgressListener(this.req.getGeneralProgressListener());
                getObjectRequest.setMatchingETagConstraints(this.req.getMatchingETagConstraints());
                getObjectRequest.setNonmatchingETagConstraints(this.req.getNonmatchingETagConstraints());
                getObjectRequest.setRequesterPays(this.req.isRequesterPays());
                getObjectRequest.setRequestCredentialsProvider(this.req.getRequestCredentialsProvider());
                getObjectRequest.setPartNumber(i);
                this.futures.add(this.executor.submit(new DownloadS3ObjectCallable(this.serviceCall(getObjectRequest), this.dstfile, l2)));
                l = ServiceUtils.getPartSize(this.req, this.s3, i);
            }
            this.lastFullyMergedPartNumber = this.lastFullyMergedPartNumber + 1;
            Future<File> future = this.executor.submit(new CompleteMultipartDownload(this.futures, this.dstfile, this.download, this.lastFullyMergedPartNumber));
            ((DownloadMonitor)this.download.getMonitor()).setFuture(future);
        }
        catch (Exception exception) {
            FileLocks.unlock(this.dstfile);
            throw exception;
        }
    }

    private Callable<S3Object> serviceCall(final GetObjectRequest getObjectRequest) {
        return new Callable<S3Object>(){

            @Override
            public S3Object call() throws Exception {
                return DownloadCallable.this.s3.getObject(getObjectRequest);
            }
        };
    }

    private void truncateDestinationFileIfNecessary() {
        RandomAccessFile randomAccessFile;
        block7: {
            randomAccessFile = null;
            if (!FileLocks.lock(this.dstfile)) {
                throw new FileLockException("Fail to lock " + this.dstfile);
            }
            try {
                randomAccessFile = new RandomAccessFile(this.dstfile, "rw");
                if (this.lastFullyMergedPartNumber == 0) {
                    randomAccessFile.setLength(0L);
                    break block7;
                }
                long l = ServiceUtils.getLastByteInPart(this.s3, this.req, this.lastFullyMergedPartNumber);
                if (this.dstfile.length() < l) {
                    throw new SdkClientException("File " + this.dstfile.getAbsolutePath() + " has been modified since last pause.");
                }
                randomAccessFile.setLength(l + 1L);
                this.download.getProgress().updateProgress(l + 1L);
            }
            catch (Exception exception) {
                try {
                    throw new SdkClientException("Unable to append part file to dstfile " + exception.getMessage(), exception);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(randomAccessFile, LOG);
                    FileLocks.unlock(this.dstfile);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly(randomAccessFile, LOG);
        FileLocks.unlock(this.dstfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustRequest(GetObjectRequest getObjectRequest) {
        long[] lArray = getObjectRequest.getRange();
        long l = lArray[1];
        long l2 = l - this.origStartingByte + 1L;
        if (this.dstfile.exists()) {
            if (!FileLocks.lock(this.dstfile)) {
                throw new FileLockException("Fail to lock " + this.dstfile + " for range adjustment");
            }
            try {
                this.expectedFileLength = this.dstfile.length();
                long l3 = this.origStartingByte + this.expectedFileLength;
                LOG.info("Adjusting request range from " + Arrays.toString(lArray) + " to " + Arrays.toString(new long[]{l3, l}) + " for file " + this.dstfile);
                getObjectRequest.setRange(l3, l);
                l2 = l - l3 + 1L;
            }
            finally {
                FileLocks.unlock(this.dstfile);
            }
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("Unable to determine the range for download operation. lastByte=" + l + ", origStartingByte=" + this.origStartingByte + ", expectedFileLength=" + this.expectedFileLength + ", totalBytesToDownload=" + l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private S3Object retryableDownloadS3ObjectToFile(File file, ServiceUtils.RetryableS3DownloadTask retryableS3DownloadTask) {
        boolean bl = false;
        while (true) {
            S3Object s3Object;
            boolean bl2;
            boolean bl3 = bl2 = this.resumeExistingDownload || this.resumeOnRetry && bl;
            if (bl2 && bl) {
                this.adjustRequest(this.req);
            }
            if ((s3Object = retryableS3DownloadTask.getS3ObjectStream()) == null) {
                return null;
            }
            try {
                if (testing && this.resumeExistingDownload && !bl) {
                    throw new SdkClientException("testing");
                }
                ServiceUtils.downloadToFile(s3Object, file, retryableS3DownloadTask.needIntegrityCheck(), bl2, this.expectedFileLength);
                S3Object s3Object2 = s3Object;
                return s3Object2;
            }
            catch (AmazonClientException amazonClientException) {
                if (!amazonClientException.isRetryable()) {
                    throw amazonClientException;
                }
                Throwable throwable = amazonClientException.getCause();
                if (throwable instanceof SocketException && !throwable.getMessage().equals("Connection reset") || throwable instanceof SSLProtocolException) {
                    throw amazonClientException;
                }
                if (bl) {
                    throw amazonClientException;
                }
                LOG.info("Retry the download of object " + s3Object.getKey() + " (bucket " + s3Object.getBucketName() + ")", amazonClientException);
                bl = true;
                continue;
            }
            finally {
                s3Object.getObjectContent().abort();
                continue;
            }
            break;
        }
    }

    static void setTesting(boolean bl) {
        testing = bl;
    }
}

