/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.services.s3.internal.XmlWriter;
import com.amazonaws.services.s3.internal.XmlWriterUtils;
import com.amazonaws.services.s3.model.DefaultRetention;
import com.amazonaws.services.s3.model.ObjectLockConfiguration;
import com.amazonaws.services.s3.model.ObjectLockRule;

public final class ObjectLockConfigurationXmlFactory {
    public byte[] convertToXmlByteArray(ObjectLockConfiguration objectLockConfiguration) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("ObjectLockConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        XmlWriterUtils.addIfNotNull(xmlWriter, "ObjectLockEnabled", objectLockConfiguration.getObjectLockEnabled());
        ObjectLockConfigurationXmlFactory.addRuleIfNotNull(xmlWriter, objectLockConfiguration.getRule());
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    private static void addRuleIfNotNull(XmlWriter xmlWriter, ObjectLockRule objectLockRule) {
        if (objectLockRule == null) {
            return;
        }
        xmlWriter.start("Rule");
        ObjectLockConfigurationXmlFactory.writeDefaultRetention(xmlWriter, objectLockRule.getDefaultRetention());
        xmlWriter.end();
    }

    private static void writeDefaultRetention(XmlWriter xmlWriter, DefaultRetention defaultRetention) {
        Integer n;
        if (defaultRetention == null) {
            return;
        }
        xmlWriter.start("DefaultRetention");
        XmlWriterUtils.addIfNotNull(xmlWriter, "Mode", defaultRetention.getMode());
        Integer n2 = defaultRetention.getDays();
        if (n2 != null) {
            xmlWriter.start("Days").value(Integer.toString(n2)).end();
        }
        if ((n = defaultRetention.getYears()) != null) {
            xmlWriter.start("Years").value(Integer.toString(n)).end();
        }
        xmlWriter.end();
    }
}

