/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.s3.model.ExpectedBucketOwnerRequest;
import com.amazonaws.services.s3.model.LegacyS3ProgressListener;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.ProgressListener;
import com.amazonaws.services.s3.model.S3DataSource;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.amazonaws.services.s3.model.SSECustomerKeyProvider;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;

public class UploadPartRequest
extends AmazonWebServiceRequest
implements ExpectedBucketOwnerRequest,
S3DataSource,
SSECustomerKeyProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    private ObjectMetadata objectMetadata;
    private String bucketName;
    private String key;
    private String uploadId;
    private int partNumber;
    private long partSize;
    private String md5Digest;
    private transient InputStream inputStream;
    private File file;
    private long fileOffset;
    private boolean isLastPart;
    private SSECustomerKey sseCustomerKey;
    private boolean isRequesterPays;
    private String expectedBucketOwner;

    @Override
    public String getExpectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    @Override
    public UploadPartRequest withExpectedBucketOwner(String string) {
        this.expectedBucketOwner = string;
        return this;
    }

    @Override
    public void setExpectedBucketOwner(String string) {
        this.withExpectedBucketOwner(string);
    }

    @Override
    public void setInputStream(InputStream inputStream2) {
        this.inputStream = inputStream2;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    public UploadPartRequest withInputStream(InputStream inputStream2) {
        this.setInputStream(inputStream2);
        return this;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String string) {
        this.bucketName = string;
    }

    public UploadPartRequest withBucketName(String string) {
        this.bucketName = string;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public UploadPartRequest withKey(String string) {
        this.key = string;
        return this;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setUploadId(String string) {
        this.uploadId = string;
    }

    public UploadPartRequest withUploadId(String string) {
        this.uploadId = string;
        return this;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(int n) {
        this.partNumber = n;
    }

    public UploadPartRequest withPartNumber(int n) {
        this.partNumber = n;
        return this;
    }

    public long getPartSize() {
        return this.partSize;
    }

    public void setPartSize(long l) {
        this.partSize = l;
    }

    public UploadPartRequest withPartSize(long l) {
        this.partSize = l;
        return this;
    }

    public String getMd5Digest() {
        return this.md5Digest;
    }

    public void setMd5Digest(String string) {
        this.md5Digest = string;
    }

    public UploadPartRequest withMD5Digest(String string) {
        this.md5Digest = string;
        return this;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void setFile(File file) {
        this.file = file;
    }

    public UploadPartRequest withFile(File file) {
        this.setFile(file);
        return this;
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public void setFileOffset(long l) {
        this.fileOffset = l;
    }

    public UploadPartRequest withFileOffset(long l) {
        this.setFileOffset(l);
        return this;
    }

    @Deprecated
    public void setProgressListener(ProgressListener progressListener) {
        this.setGeneralProgressListener(new LegacyS3ProgressListener(progressListener));
    }

    @Deprecated
    public ProgressListener getProgressListener() {
        com.amazonaws.event.ProgressListener progressListener = this.getGeneralProgressListener();
        if (progressListener instanceof LegacyS3ProgressListener) {
            return ((LegacyS3ProgressListener)progressListener).unwrap();
        }
        return null;
    }

    @Deprecated
    public UploadPartRequest withProgressListener(ProgressListener progressListener) {
        this.setProgressListener(progressListener);
        return this;
    }

    public boolean isLastPart() {
        return this.isLastPart;
    }

    public void setLastPart(boolean bl) {
        this.isLastPart = bl;
    }

    public UploadPartRequest withLastPart(boolean bl) {
        this.setLastPart(bl);
        return this;
    }

    @Override
    public SSECustomerKey getSSECustomerKey() {
        return this.sseCustomerKey;
    }

    public void setSSECustomerKey(SSECustomerKey sSECustomerKey) {
        this.sseCustomerKey = sSECustomerKey;
    }

    public UploadPartRequest withSSECustomerKey(SSECustomerKey sSECustomerKey) {
        this.setSSECustomerKey(sSECustomerKey);
        return this;
    }

    public ObjectMetadata getObjectMetadata() {
        return this.objectMetadata;
    }

    public void setObjectMetadata(ObjectMetadata objectMetadata) {
        this.objectMetadata = objectMetadata;
    }

    public UploadPartRequest withObjectMetadata(ObjectMetadata objectMetadata) {
        this.setObjectMetadata(objectMetadata);
        return this;
    }

    public boolean isRequesterPays() {
        return this.isRequesterPays;
    }

    public void setRequesterPays(boolean bl) {
        this.isRequesterPays = bl;
    }

    public UploadPartRequest withRequesterPays(boolean bl) {
        this.setRequesterPays(bl);
        return this;
    }
}

