/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.internal.MetricAware;
import com.amazonaws.internal.SdkFilterInputStream;
import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.metrics.MetricFilterInputStream;
import com.amazonaws.services.s3.metrics.S3ServiceMetric;
import com.amazonaws.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.client.methods.HttpRequestBase;

public class S3ObjectInputStream
extends SdkFilterInputStream {
    private final HttpRequestBase httpRequest;

    public S3ObjectInputStream(InputStream inputStream2, HttpRequestBase httpRequestBase) {
        this(inputStream2, httpRequestBase, S3ObjectInputStream.wrapWithByteCounting(inputStream2));
    }

    public S3ObjectInputStream(InputStream inputStream2, HttpRequestBase httpRequestBase, boolean bl) {
        super(bl ? new MetricFilterInputStream(S3ServiceMetric.S3DownloadThroughput, inputStream2) : inputStream2);
        this.httpRequest = httpRequestBase;
    }

    private static boolean wrapWithByteCounting(InputStream inputStream2) {
        if (!AwsSdkMetrics.isMetricsEnabled()) {
            return false;
        }
        if (inputStream2 instanceof MetricAware) {
            MetricAware metricAware = (MetricAware)((Object)inputStream2);
            return !metricAware.isMetricActivated();
        }
        return true;
    }

    @Override
    public void abort() {
        super.abort();
        if (this.httpRequest != null) {
            this.httpRequest.abort();
        }
        if (!(this.in instanceof SdkFilterInputStream)) {
            IOUtils.closeQuietly(this.in, null);
        }
    }

    public HttpRequestBase getHttpRequest() {
        return this.httpRequest;
    }

    @Override
    public int available() throws IOException {
        int n = super.available();
        return n == 0 ? 1 : n;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }
}

