/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.annotation.Immutable;
import com.amazonaws.services.s3.model.InstructionFileId;
import com.amazonaws.services.s3.model.S3ObjectIdBuilder;
import java.io.Serializable;

@Immutable
public class S3ObjectId
implements Serializable {
    private final String bucket;
    private final String key;
    private final String versionId;

    public S3ObjectId(String string, String string2) {
        this(string, string2, null);
    }

    public S3ObjectId(String string, String string2, String string3) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("bucket and key must be specified");
        }
        this.bucket = string;
        this.key = string2;
        this.versionId = string3;
    }

    public S3ObjectId(S3ObjectIdBuilder s3ObjectIdBuilder) {
        this.bucket = s3ObjectIdBuilder.getBucket();
        this.key = s3ObjectIdBuilder.getKey();
        this.versionId = s3ObjectIdBuilder.getVersionId();
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public InstructionFileId instructionFileId() {
        return this.instructionFileId(null);
    }

    public InstructionFileId instructionFileId(String string) {
        String string2 = this.key + ".";
        string2 = string2 + (string == null || string.trim().length() == 0 ? "instruction" : string);
        return new InstructionFileId(this.bucket, string2, this.versionId);
    }

    public String toString() {
        return "bucket: " + this.bucket + ", key: " + this.key + ", versionId: " + this.versionId;
    }
}

