/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.Encryption;
import com.amazonaws.services.s3.model.MetadataEntry;
import com.amazonaws.services.s3.model.ObjectTagging;
import com.amazonaws.services.s3.model.StorageClass;
import java.io.Serializable;
import java.util.List;

public class S3Location
implements Serializable,
Cloneable {
    private String bucketName;
    private String prefix;
    private Encryption encryption;
    private String cannedACL;
    private AccessControlList accessControlList;
    private ObjectTagging tagging;
    private List<MetadataEntry> userMetadata;
    private String storageClass;

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String string) {
        this.bucketName = string;
    }

    public S3Location withBucketName(String string) {
        this.setBucketName(string);
        return this;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public S3Location withPrefix(String string) {
        this.setPrefix(string);
        return this;
    }

    public Encryption getEncryption() {
        return this.encryption;
    }

    public void setEncryption(Encryption encryption) {
        this.encryption = encryption;
    }

    public S3Location withEncryption(Encryption encryption) {
        this.setEncryption(encryption);
        return this;
    }

    public String getCannedACL() {
        return this.cannedACL;
    }

    public void setCannedACL(String string) {
        this.cannedACL = string;
    }

    public S3Location withCannedACL(String string) {
        this.setCannedACL(string);
        return this;
    }

    public S3Location withCannedACL(CannedAccessControlList cannedAccessControlList) {
        this.setCannedACL(cannedAccessControlList == null ? null : cannedAccessControlList.toString());
        return this;
    }

    public AccessControlList getAccessControlList() {
        return this.accessControlList;
    }

    public void setAccessControlList(AccessControlList accessControlList) {
        this.accessControlList = accessControlList;
    }

    public S3Location withAccessControlList(AccessControlList accessControlList) {
        this.setAccessControlList(accessControlList);
        return this;
    }

    public ObjectTagging getTagging() {
        return this.tagging;
    }

    public void setTagging(ObjectTagging objectTagging) {
        this.tagging = objectTagging;
    }

    public S3Location withTagging(ObjectTagging objectTagging) {
        this.setTagging(objectTagging);
        return this;
    }

    public List<MetadataEntry> getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(List<MetadataEntry> list) {
        this.userMetadata = list;
    }

    public S3Location withUserMetaData(List<MetadataEntry> list) {
        this.setUserMetadata(list);
        return this;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String string) {
        this.storageClass = string;
    }

    public S3Location withStorageClass(String string) {
        this.setStorageClass(string);
        return this;
    }

    public S3Location withStorageClass(StorageClass storageClass) {
        this.setStorageClass(storageClass == null ? null : storageClass.toString());
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof S3Location)) {
            return false;
        }
        S3Location s3Location = (S3Location)object;
        if (s3Location.getBucketName() == null ^ this.getBucketName() == null) {
            return false;
        }
        if (s3Location.getBucketName() != null && !s3Location.getBucketName().equals(this.getBucketName())) {
            return false;
        }
        if (s3Location.getPrefix() == null ^ this.getPrefix() == null) {
            return false;
        }
        if (s3Location.getPrefix() != null && !s3Location.getPrefix().equals(this.getPrefix())) {
            return false;
        }
        if (s3Location.getEncryption() == null ^ this.getEncryption() == null) {
            return false;
        }
        if (s3Location.getEncryption() != null && !s3Location.getEncryption().equals(this.getEncryption())) {
            return false;
        }
        if (s3Location.getCannedACL() == null ^ this.getCannedACL() == null) {
            return false;
        }
        if (s3Location.getCannedACL() != null && !s3Location.getCannedACL().equals(this.getCannedACL())) {
            return false;
        }
        if (s3Location.getAccessControlList() == null ^ this.getAccessControlList() == null) {
            return false;
        }
        if (s3Location.getAccessControlList() != null && !s3Location.getAccessControlList().equals(this.getAccessControlList())) {
            return false;
        }
        if (s3Location.getTagging() == null ^ this.getTagging() == null) {
            return false;
        }
        if (s3Location.getTagging() != null && !s3Location.getTagging().equals(this.getTagging())) {
            return false;
        }
        if (s3Location.getUserMetadata() == null ^ this.getUserMetadata() == null) {
            return false;
        }
        if (s3Location.getUserMetadata() != null && !s3Location.getUserMetadata().equals(this.getUserMetadata())) {
            return false;
        }
        if (s3Location.getStorageClass() == null ^ this.getStorageClass() == null) {
            return false;
        }
        return s3Location.getStorageClass() == null || s3Location.getStorageClass().equals(this.getStorageClass());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getBucketName() == null ? 0 : this.getBucketName().hashCode());
        n2 = 31 * n2 + (this.getPrefix() == null ? 0 : this.getPrefix().hashCode());
        n2 = 31 * n2 + (this.getEncryption() == null ? 0 : this.getEncryption().hashCode());
        n2 = 31 * n2 + (this.getCannedACL() == null ? 0 : this.getCannedACL().hashCode());
        n2 = 31 * n2 + (this.getAccessControlList() == null ? 0 : this.getAccessControlList().hashCode());
        n2 = 31 * n2 + (this.getTagging() != null ? this.getTagging().hashCode() : 0);
        n2 = 31 * n2 + (this.getUserMetadata() != null ? this.getUserMetadata().hashCode() : 0);
        n2 = 31 * n2 + (this.getStorageClass() != null ? this.getStorageClass().hashCode() : 0);
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getBucketName() != null) {
            stringBuilder.append("BucketName: ").append(this.getBucketName()).append(",");
        }
        if (this.getPrefix() != null) {
            stringBuilder.append("Prefix: ").append(this.getPrefix()).append(",");
        }
        if (this.getEncryption() != null) {
            stringBuilder.append("Encryption: ").append(this.getEncryption()).append(",");
        }
        if (this.getCannedACL() != null) {
            stringBuilder.append("CannedACL: ").append(this.getCannedACL()).append(",");
        }
        if (this.getAccessControlList() != null) {
            stringBuilder.append("AccessControlList: ").append(this.getAccessControlList()).append(",");
        }
        if (this.getTagging() != null) {
            stringBuilder.append("Tagging: ").append(this.getTagging()).append(",");
        }
        if (this.getUserMetadata() != null) {
            stringBuilder.append("UserMetadata: ").append(this.getUserMetadata()).append(",");
        }
        if (this.getStorageClass() != null) {
            stringBuilder.append("StorageClass: ").append(this.getStorageClass());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public S3Location clone() {
        try {
            return (S3Location)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", cloneNotSupportedException);
        }
    }
}

