/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.internal.ObjectExpirationResult;
import com.amazonaws.services.s3.internal.ObjectRestoreResult;
import com.amazonaws.services.s3.internal.S3RequesterChargedResult;
import com.amazonaws.services.s3.internal.ServerSideEncryptionResult;
import com.amazonaws.services.s3.model.SSEAlgorithm;
import com.amazonaws.util.DateUtils;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

public class ObjectMetadata
implements ObjectExpirationResult,
ObjectRestoreResult,
S3RequesterChargedResult,
ServerSideEncryptionResult,
Serializable,
Cloneable {
    private Map<String, String> userMetadata = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, Object> metadata = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    public static final String AES_256_SERVER_SIDE_ENCRYPTION = SSEAlgorithm.AES256.getAlgorithm();
    private Date httpExpiresDate;
    private Date expirationTime;
    private String expirationTimeRuleId;
    private Boolean ongoingRestore;
    private Date restoreExpirationTime;
    private Boolean bucketKeyEnabled;

    public ObjectMetadata() {
    }

    private ObjectMetadata(ObjectMetadata objectMetadata) {
        this.userMetadata = objectMetadata.userMetadata == null ? null : new TreeMap<String, String>(objectMetadata.userMetadata);
        this.metadata = objectMetadata.metadata == null ? null : new TreeMap<String, Object>(objectMetadata.metadata);
        this.expirationTime = DateUtils.cloneDate(objectMetadata.expirationTime);
        this.expirationTimeRuleId = objectMetadata.expirationTimeRuleId;
        this.httpExpiresDate = DateUtils.cloneDate(objectMetadata.httpExpiresDate);
        this.ongoingRestore = objectMetadata.ongoingRestore;
        this.restoreExpirationTime = DateUtils.cloneDate(objectMetadata.restoreExpirationTime);
        this.bucketKeyEnabled = objectMetadata.bucketKeyEnabled;
    }

    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, String> map) {
        this.userMetadata = map;
    }

    public void setHeader(String string, Object object) {
        this.metadata.put(string, object);
    }

    public void addUserMetadata(String string, String string2) {
        this.userMetadata.put(string, string2);
    }

    public Map<String, Object> getRawMetadata() {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        treeMap.putAll(this.metadata);
        return Collections.unmodifiableMap(treeMap);
    }

    public Object getRawMetadataValue(String string) {
        return this.metadata.get(string);
    }

    public Date getLastModified() {
        return DateUtils.cloneDate((Date)this.metadata.get("Last-Modified"));
    }

    public void setLastModified(Date date) {
        this.metadata.put("Last-Modified", date);
    }

    public long getContentLength() {
        Long l = (Long)this.metadata.get("Content-Length");
        if (l == null) {
            return 0L;
        }
        return l;
    }

    public long getInstanceLength() {
        int n;
        String string = (String)this.metadata.get("Content-Range");
        if (string != null && (n = string.lastIndexOf("/")) >= 0) {
            return Long.parseLong(string.substring(n + 1));
        }
        return this.getContentLength();
    }

    public void setContentLength(long l) {
        this.metadata.put("Content-Length", l);
    }

    public String getContentType() {
        return (String)this.metadata.get("Content-Type");
    }

    public void setContentType(String string) {
        this.metadata.put("Content-Type", string);
    }

    public String getContentLanguage() {
        return (String)this.metadata.get("Content-Language");
    }

    public void setContentLanguage(String string) {
        this.metadata.put("Content-Language", string);
    }

    public String getContentEncoding() {
        return (String)this.metadata.get("Content-Encoding");
    }

    public void setContentEncoding(String string) {
        this.metadata.put("Content-Encoding", string);
    }

    public String getCacheControl() {
        return (String)this.metadata.get("Cache-Control");
    }

    public void setCacheControl(String string) {
        this.metadata.put("Cache-Control", string);
    }

    public void setContentMD5(String string) {
        if (string == null) {
            this.metadata.remove("Content-MD5");
        } else {
            this.metadata.put("Content-MD5", string);
        }
    }

    public String getContentMD5() {
        return (String)this.metadata.get("Content-MD5");
    }

    public void setContentDisposition(String string) {
        this.metadata.put("Content-Disposition", string);
    }

    public String getContentDisposition() {
        return (String)this.metadata.get("Content-Disposition");
    }

    public String getETag() {
        return (String)this.metadata.get("ETag");
    }

    public String getVersionId() {
        return (String)this.metadata.get("x-amz-version-id");
    }

    @Override
    public String getSSEAlgorithm() {
        return (String)this.metadata.get("x-amz-server-side-encryption");
    }

    @Deprecated
    public String getServerSideEncryption() {
        return (String)this.metadata.get("x-amz-server-side-encryption");
    }

    @Override
    public void setSSEAlgorithm(String string) {
        this.metadata.put("x-amz-server-side-encryption", string);
    }

    @Deprecated
    public void setServerSideEncryption(String string) {
        this.metadata.put("x-amz-server-side-encryption", string);
    }

    @Override
    public String getSSECustomerAlgorithm() {
        return (String)this.metadata.get("x-amz-server-side-encryption-customer-algorithm");
    }

    @Override
    public void setSSECustomerAlgorithm(String string) {
        this.metadata.put("x-amz-server-side-encryption-customer-algorithm", string);
    }

    @Override
    public String getSSECustomerKeyMd5() {
        return (String)this.metadata.get("x-amz-server-side-encryption-customer-key-MD5");
    }

    @Override
    public void setSSECustomerKeyMd5(String string) {
        this.metadata.put("x-amz-server-side-encryption-customer-key-MD5", string);
    }

    @Override
    public Date getExpirationTime() {
        return DateUtils.cloneDate(this.expirationTime);
    }

    @Override
    public void setExpirationTime(Date date) {
        this.expirationTime = date;
    }

    @Override
    public String getExpirationTimeRuleId() {
        return this.expirationTimeRuleId;
    }

    @Override
    public void setExpirationTimeRuleId(String string) {
        this.expirationTimeRuleId = string;
    }

    @Override
    public Date getRestoreExpirationTime() {
        return DateUtils.cloneDate(this.restoreExpirationTime);
    }

    @Override
    public void setRestoreExpirationTime(Date date) {
        this.restoreExpirationTime = date;
    }

    @Override
    public void setOngoingRestore(boolean bl) {
        this.ongoingRestore = bl;
    }

    @Override
    public Boolean getOngoingRestore() {
        return this.ongoingRestore;
    }

    public void setHttpExpiresDate(Date date) {
        this.httpExpiresDate = date;
    }

    public Date getHttpExpiresDate() {
        return DateUtils.cloneDate(this.httpExpiresDate);
    }

    public String getStorageClass() {
        Object object = this.metadata.get("x-amz-storage-class");
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public String getArchiveStatus() {
        Object object = this.metadata.get("x-amz-archive-status");
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public String getUserMetaDataOf(String string) {
        return this.userMetadata == null ? null : this.userMetadata.get(string);
    }

    public ObjectMetadata clone() {
        return new ObjectMetadata(this);
    }

    public String getSSEAwsKmsKeyId() {
        return (String)this.metadata.get("x-amz-server-side-encryption-aws-kms-key-id");
    }

    public String getSSEAwsKmsEncryptionContext() {
        return (String)this.metadata.get("x-amz-server-side-encryption-context");
    }

    @Override
    public boolean isRequesterCharged() {
        return this.metadata.get("x-amz-request-charged") != null;
    }

    @Override
    public void setRequesterCharged(boolean bl) {
        if (bl) {
            this.metadata.put("x-amz-request-charged", "requester");
        }
    }

    public Integer getPartCount() {
        return (Integer)this.metadata.get("x-amz-mp-parts-count");
    }

    public Long[] getContentRange() {
        String string = (String)this.metadata.get("Content-Range");
        Long[] longArray = null;
        if (string != null) {
            String[] stringArray = string.split("[ -/]+");
            try {
                longArray = new Long[]{Long.parseLong(stringArray[1]), Long.parseLong(stringArray[2])};
            }
            catch (NumberFormatException numberFormatException) {
                throw new SdkClientException("Unable to parse content range. Header 'Content-Range' has corrupted data" + numberFormatException.getMessage(), numberFormatException);
            }
        }
        return longArray;
    }

    public String getReplicationStatus() {
        return (String)this.metadata.get("x-amz-replication-status");
    }

    public String getObjectLockMode() {
        return (String)this.metadata.get("x-amz-object-lock-mode");
    }

    public Date getObjectLockRetainUntilDate() {
        String string = (String)this.metadata.get("x-amz-object-lock-retain-until-date");
        if (string != null) {
            return DateUtils.parseISO8601Date(string);
        }
        return null;
    }

    public String getObjectLockLegalHoldStatus() {
        return (String)this.metadata.get("x-amz-object-lock-legal-hold");
    }

    @Override
    public Boolean getBucketKeyEnabled() {
        return this.bucketKeyEnabled;
    }

    @Override
    public void setBucketKeyEnabled(Boolean bl) {
        this.bucketKeyEnabled = bl;
    }
}

