/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.s3.model.ExpectedBucketOwnerRequest;
import com.amazonaws.services.s3.model.LegacyS3ProgressListener;
import com.amazonaws.services.s3.model.ProgressListener;
import com.amazonaws.services.s3.model.ResponseHeaderOverrides;
import com.amazonaws.services.s3.model.S3ObjectId;
import com.amazonaws.services.s3.model.S3ObjectIdBuilder;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.amazonaws.services.s3.model.SSECustomerKeyProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class GetObjectRequest
extends AmazonWebServiceRequest
implements ExpectedBucketOwnerRequest,
SSECustomerKeyProvider,
Serializable {
    private S3ObjectIdBuilder s3ObjectIdBuilder = new S3ObjectIdBuilder();
    private long[] range;
    private List<String> matchingETagConstraints = new ArrayList<String>();
    private List<String> nonmatchingEtagConstraints = new ArrayList<String>();
    private Date unmodifiedSinceConstraint;
    private Date modifiedSinceConstraint;
    private ResponseHeaderOverrides responseHeaders;
    private boolean isRequesterPays;
    private SSECustomerKey sseCustomerKey;
    private Integer partNumber;
    private String expectedBucketOwner;

    public GetObjectRequest(String string, String string2) {
        this(string, string2, null);
    }

    public GetObjectRequest(String string, String string2, String string3) {
        this.setBucketName(string);
        this.setKey(string2);
        this.setVersionId(string3);
    }

    public GetObjectRequest(S3ObjectId s3ObjectId) {
        this.s3ObjectIdBuilder = new S3ObjectIdBuilder(s3ObjectId);
    }

    public GetObjectRequest(String string, String string2, boolean bl) {
        this.s3ObjectIdBuilder.withBucket(string).withKey(string2);
        this.isRequesterPays = bl;
    }

    @Override
    public String getExpectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    @Override
    public GetObjectRequest withExpectedBucketOwner(String string) {
        this.expectedBucketOwner = string;
        return this;
    }

    @Override
    public void setExpectedBucketOwner(String string) {
        this.withExpectedBucketOwner(string);
    }

    public String getBucketName() {
        return this.s3ObjectIdBuilder.getBucket();
    }

    public void setBucketName(String string) {
        this.s3ObjectIdBuilder.setBucket(string);
    }

    public GetObjectRequest withBucketName(String string) {
        this.setBucketName(string);
        return this;
    }

    public String getKey() {
        return this.s3ObjectIdBuilder.getKey();
    }

    public void setKey(String string) {
        this.s3ObjectIdBuilder.setKey(string);
    }

    public GetObjectRequest withKey(String string) {
        this.setKey(string);
        return this;
    }

    public String getVersionId() {
        return this.s3ObjectIdBuilder.getVersionId();
    }

    public void setVersionId(String string) {
        this.s3ObjectIdBuilder.setVersionId(string);
    }

    public GetObjectRequest withVersionId(String string) {
        this.setVersionId(string);
        return this;
    }

    public long[] getRange() {
        return this.range == null ? null : (long[])this.range.clone();
    }

    public void setRange(long l, long l2) {
        this.range = new long[]{l, l2};
    }

    public void setRange(long l) {
        this.setRange(l, 0x7FFFFFFFFFFFFFFEL);
    }

    public GetObjectRequest withRange(long l, long l2) {
        this.setRange(l, l2);
        return this;
    }

    public GetObjectRequest withRange(long l) {
        this.setRange(l);
        return this;
    }

    public List<String> getMatchingETagConstraints() {
        return this.matchingETagConstraints;
    }

    public void setMatchingETagConstraints(List<String> list) {
        this.matchingETagConstraints = list;
    }

    public GetObjectRequest withMatchingETagConstraint(String string) {
        this.matchingETagConstraints.add(string);
        return this;
    }

    public List<String> getNonmatchingETagConstraints() {
        return this.nonmatchingEtagConstraints;
    }

    public void setNonmatchingETagConstraints(List<String> list) {
        this.nonmatchingEtagConstraints = list;
    }

    public GetObjectRequest withNonmatchingETagConstraint(String string) {
        this.nonmatchingEtagConstraints.add(string);
        return this;
    }

    public Date getUnmodifiedSinceConstraint() {
        return this.unmodifiedSinceConstraint;
    }

    public void setUnmodifiedSinceConstraint(Date date) {
        this.unmodifiedSinceConstraint = date;
    }

    public GetObjectRequest withUnmodifiedSinceConstraint(Date date) {
        this.setUnmodifiedSinceConstraint(date);
        return this;
    }

    public Date getModifiedSinceConstraint() {
        return this.modifiedSinceConstraint;
    }

    public void setModifiedSinceConstraint(Date date) {
        this.modifiedSinceConstraint = date;
    }

    public GetObjectRequest withModifiedSinceConstraint(Date date) {
        this.setModifiedSinceConstraint(date);
        return this;
    }

    public ResponseHeaderOverrides getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(ResponseHeaderOverrides responseHeaderOverrides) {
        this.responseHeaders = responseHeaderOverrides;
    }

    public GetObjectRequest withResponseHeaders(ResponseHeaderOverrides responseHeaderOverrides) {
        this.setResponseHeaders(responseHeaderOverrides);
        return this;
    }

    @Deprecated
    public void setProgressListener(ProgressListener progressListener) {
        this.setGeneralProgressListener(new LegacyS3ProgressListener(progressListener));
    }

    @Deprecated
    public ProgressListener getProgressListener() {
        com.amazonaws.event.ProgressListener progressListener = this.getGeneralProgressListener();
        if (progressListener instanceof LegacyS3ProgressListener) {
            return ((LegacyS3ProgressListener)progressListener).unwrap();
        }
        return null;
    }

    @Deprecated
    public GetObjectRequest withProgressListener(ProgressListener progressListener) {
        this.setProgressListener(progressListener);
        return this;
    }

    public boolean isRequesterPays() {
        return this.isRequesterPays;
    }

    public void setRequesterPays(boolean bl) {
        this.isRequesterPays = bl;
    }

    public GetObjectRequest withRequesterPays(boolean bl) {
        this.setRequesterPays(bl);
        return this;
    }

    @Override
    public SSECustomerKey getSSECustomerKey() {
        return this.sseCustomerKey;
    }

    public void setSSECustomerKey(SSECustomerKey sSECustomerKey) {
        this.sseCustomerKey = sSECustomerKey;
    }

    public GetObjectRequest withSSECustomerKey(SSECustomerKey sSECustomerKey) {
        this.setSSECustomerKey(sSECustomerKey);
        return this;
    }

    public Integer getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(Integer n) {
        this.partNumber = n;
    }

    public GetObjectRequest withPartNumber(Integer n) {
        this.setPartNumber(n);
        return this;
    }

    public S3ObjectId getS3ObjectId() {
        return this.s3ObjectIdBuilder.build();
    }

    public void setS3ObjectId(S3ObjectId s3ObjectId) {
        this.s3ObjectIdBuilder = new S3ObjectIdBuilder(s3ObjectId);
    }

    public GetObjectRequest withS3ObjectId(S3ObjectId s3ObjectId) {
        this.setS3ObjectId(s3ObjectId);
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GetObjectRequest getObjectRequest = (GetObjectRequest)object;
        if (this.isRequesterPays != getObjectRequest.isRequesterPays) {
            return false;
        }
        if (this.s3ObjectIdBuilder != null ? !this.s3ObjectIdBuilder.equals(getObjectRequest.s3ObjectIdBuilder) : getObjectRequest.s3ObjectIdBuilder != null) {
            return false;
        }
        if (!Arrays.equals(this.range, getObjectRequest.range)) {
            return false;
        }
        if (this.matchingETagConstraints != null ? !this.matchingETagConstraints.equals(getObjectRequest.matchingETagConstraints) : getObjectRequest.matchingETagConstraints != null) {
            return false;
        }
        if (this.nonmatchingEtagConstraints != null ? !this.nonmatchingEtagConstraints.equals(getObjectRequest.nonmatchingEtagConstraints) : getObjectRequest.nonmatchingEtagConstraints != null) {
            return false;
        }
        if (this.unmodifiedSinceConstraint != null ? !this.unmodifiedSinceConstraint.equals(getObjectRequest.unmodifiedSinceConstraint) : getObjectRequest.unmodifiedSinceConstraint != null) {
            return false;
        }
        if (this.modifiedSinceConstraint != null ? !this.modifiedSinceConstraint.equals(getObjectRequest.modifiedSinceConstraint) : getObjectRequest.modifiedSinceConstraint != null) {
            return false;
        }
        if (this.responseHeaders != null ? !this.responseHeaders.equals(getObjectRequest.responseHeaders) : getObjectRequest.responseHeaders != null) {
            return false;
        }
        if (this.sseCustomerKey != null ? !this.sseCustomerKey.equals(getObjectRequest.sseCustomerKey) : getObjectRequest.sseCustomerKey != null) {
            return false;
        }
        return this.partNumber != null ? this.partNumber.equals(getObjectRequest.partNumber) : getObjectRequest.partNumber == null;
    }

    public int hashCode() {
        int n = this.s3ObjectIdBuilder != null ? this.s3ObjectIdBuilder.hashCode() : 0;
        n = 31 * n + Arrays.hashCode(this.range);
        n = 31 * n + (this.matchingETagConstraints != null ? this.matchingETagConstraints.hashCode() : 0);
        n = 31 * n + (this.nonmatchingEtagConstraints != null ? this.nonmatchingEtagConstraints.hashCode() : 0);
        n = 31 * n + (this.unmodifiedSinceConstraint != null ? this.unmodifiedSinceConstraint.hashCode() : 0);
        n = 31 * n + (this.modifiedSinceConstraint != null ? this.modifiedSinceConstraint.hashCode() : 0);
        n = 31 * n + (this.responseHeaders != null ? this.responseHeaders.hashCode() : 0);
        n = 31 * n + (this.isRequesterPays ? 1 : 0);
        n = 31 * n + (this.sseCustomerKey != null ? this.sseCustomerKey.hashCode() : 0);
        n = 31 * n + (this.partNumber != null ? this.partNumber.hashCode() : 0);
        return n;
    }
}

