/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ExtraMaterialsDescription
implements Serializable {
    public static final ExtraMaterialsDescription NONE = new ExtraMaterialsDescription(Collections.EMPTY_MAP);
    private final Map<String, String> extra;
    private final ConflictResolution resolve;

    public ExtraMaterialsDescription(Map<String, String> map) {
        this(map, ConflictResolution.FAIL_FAST);
    }

    public ExtraMaterialsDescription(Map<String, String> map, ConflictResolution conflictResolution) {
        if (map == null || conflictResolution == null) {
            throw new IllegalArgumentException();
        }
        this.extra = Collections.unmodifiableMap(new HashMap<String, String>(map));
        this.resolve = conflictResolution;
    }

    public Map<String, String> getMaterialDescription() {
        return this.extra;
    }

    public ConflictResolution getConflictResolution() {
        return this.resolve;
    }

    public Map<String, String> mergeInto(Map<String, String> map) {
        if (this.extra.size() == 0) {
            return map;
        }
        if (map == null || map.size() == 0) {
            return this.extra;
        }
        switch (this.resolve) {
            case FAIL_FAST: {
                int n = map.size() + this.extra.size();
                HashMap<String, String> hashMap = new HashMap<String, String>(map);
                hashMap.putAll(this.extra);
                if (n != hashMap.size()) {
                    throw new IllegalArgumentException("The supplemental material descriptions contains conflicting entries");
                }
                return Collections.unmodifiableMap(hashMap);
            }
            case OVERRIDDEN: {
                HashMap<String, String> hashMap = new HashMap<String, String>(this.extra);
                hashMap.putAll(map);
                return Collections.unmodifiableMap(hashMap);
            }
            case OVERRIDE: {
                HashMap<String, String> hashMap = new HashMap<String, String>(map);
                hashMap.putAll(this.extra);
                return Collections.unmodifiableMap(hashMap);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static enum ConflictResolution {
        FAIL_FAST,
        OVERRIDE,
        OVERRIDDEN;

    }
}

