/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.s3.model.ExpectedBucketOwnerRequest;
import com.amazonaws.services.s3.model.MultiFactorAuthentication;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class DeleteObjectsRequest
extends AmazonWebServiceRequest
implements ExpectedBucketOwnerRequest,
Serializable {
    private String bucketName;
    private boolean quiet;
    private MultiFactorAuthentication mfa;
    private final List<KeyVersion> keys = new ArrayList<KeyVersion>();
    private boolean isRequesterPays;
    private boolean bypassGovernanceRetention;
    private String expectedBucketOwner;

    public DeleteObjectsRequest(String string) {
        this.setBucketName(string);
    }

    @Override
    public String getExpectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    @Override
    public DeleteObjectsRequest withExpectedBucketOwner(String string) {
        this.expectedBucketOwner = string;
        return this;
    }

    @Override
    public void setExpectedBucketOwner(String string) {
        this.withExpectedBucketOwner(string);
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String string) {
        this.bucketName = string;
    }

    public DeleteObjectsRequest withBucketName(String string) {
        this.setBucketName(string);
        return this;
    }

    public MultiFactorAuthentication getMfa() {
        return this.mfa;
    }

    public void setMfa(MultiFactorAuthentication multiFactorAuthentication) {
        this.mfa = multiFactorAuthentication;
    }

    public DeleteObjectsRequest withMfa(MultiFactorAuthentication multiFactorAuthentication) {
        this.setMfa(multiFactorAuthentication);
        return this;
    }

    public void setQuiet(boolean bl) {
        this.quiet = bl;
    }

    public boolean getQuiet() {
        return this.quiet;
    }

    public DeleteObjectsRequest withQuiet(boolean bl) {
        this.setQuiet(bl);
        return this;
    }

    public void setKeys(List<KeyVersion> list) {
        this.keys.clear();
        this.keys.addAll(list);
    }

    public DeleteObjectsRequest withKeys(List<KeyVersion> list) {
        this.setKeys(list);
        return this;
    }

    public List<KeyVersion> getKeys() {
        return this.keys;
    }

    public DeleteObjectsRequest withKeys(String ... stringArray) {
        ArrayList<KeyVersion> arrayList = new ArrayList<KeyVersion>(stringArray.length);
        for (String string : stringArray) {
            arrayList.add(new KeyVersion(string));
        }
        this.setKeys(arrayList);
        return this;
    }

    public boolean isRequesterPays() {
        return this.isRequesterPays;
    }

    public void setRequesterPays(boolean bl) {
        this.isRequesterPays = bl;
    }

    public DeleteObjectsRequest withRequesterPays(boolean bl) {
        this.setRequesterPays(bl);
        return this;
    }

    public boolean getBypassGovernanceRetention() {
        return this.bypassGovernanceRetention;
    }

    public DeleteObjectsRequest withBypassGovernanceRetention(boolean bl) {
        this.bypassGovernanceRetention = bl;
        return this;
    }

    public void setBypassGovernanceRetention(boolean bl) {
        this.withBypassGovernanceRetention(bl);
    }

    public static class KeyVersion
    implements Serializable {
        private final String key;
        private final String version;

        public KeyVersion(String string) {
            this(string, null);
        }

        public KeyVersion(String string, String string2) {
            this.key = string;
            this.version = string2;
        }

        public String getKey() {
            return this.key;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

