/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.regions.Region;
import com.amazonaws.services.s3.internal.crypto.CryptoRuntime;
import com.amazonaws.services.s3.model.CryptoMode;
import com.amazonaws.services.s3.model.CryptoRangeGetMode;
import com.amazonaws.services.s3.model.CryptoStorageMode;
import java.io.Serializable;
import java.security.Provider;
import java.security.SecureRandom;

public class CryptoConfigurationV2
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8646831898339939580L;
    private static final SecureRandom SRAND = new SecureRandom();
    private CryptoMode cryptoMode;
    private CryptoStorageMode storageMode;
    private Provider cryptoProvider;
    private boolean alwaysUseCryptoProvider;
    private SecureRandom secureRandom;
    private boolean unsafeUndecryptableObjectPassthrough = false;
    private transient Region awsKmsRegion;
    private CryptoRangeGetMode rangeGetMode = CryptoRangeGetMode.DISABLED;

    public CryptoConfigurationV2() {
        this(CryptoMode.StrictAuthenticatedEncryption);
    }

    public CryptoConfigurationV2(CryptoMode cryptoMode) {
        this.checkCryptoMode(cryptoMode);
        this.storageMode = CryptoStorageMode.ObjectMetadata;
        this.cryptoProvider = null;
        this.secureRandom = SRAND;
        this.cryptoMode = cryptoMode;
    }

    public void setStorageMode(CryptoStorageMode cryptoStorageMode) {
        this.storageMode = cryptoStorageMode;
    }

    public CryptoConfigurationV2 withStorageMode(CryptoStorageMode cryptoStorageMode) {
        this.storageMode = cryptoStorageMode;
        return this;
    }

    public CryptoStorageMode getStorageMode() {
        return this.storageMode;
    }

    public void setCryptoProvider(Provider provider) {
        this.cryptoProvider = provider;
    }

    public CryptoConfigurationV2 withCryptoProvider(Provider provider) {
        this.cryptoProvider = provider;
        return this;
    }

    public Provider getCryptoProvider() {
        return this.cryptoProvider;
    }

    public void setAlwaysUseCryptoProvider(boolean bl) {
        this.alwaysUseCryptoProvider = bl;
    }

    public CryptoConfigurationV2 withAlwaysUseCryptoProvider(boolean bl) {
        this.alwaysUseCryptoProvider = bl;
        return this;
    }

    public boolean getAlwaysUseCryptoProvider() {
        return this.alwaysUseCryptoProvider;
    }

    public SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }

    public CryptoConfigurationV2 withSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
        return this;
    }

    public CryptoMode getCryptoMode() {
        return this.cryptoMode;
    }

    public void setCryptoMode(CryptoMode cryptoMode) throws UnsupportedOperationException {
        this.checkCryptoMode(cryptoMode);
        this.cryptoMode = cryptoMode;
    }

    public CryptoConfigurationV2 withCryptoMode(CryptoMode cryptoMode) throws UnsupportedOperationException {
        this.checkCryptoMode(cryptoMode);
        this.cryptoMode = cryptoMode;
        return this;
    }

    public boolean isUnsafeUndecryptableObjectPassthrough() {
        return this.unsafeUndecryptableObjectPassthrough;
    }

    public void setUnsafeUndecryptableObjectPassthrough(boolean bl) {
        this.unsafeUndecryptableObjectPassthrough = bl;
    }

    public CryptoConfigurationV2 withUnsafeUndecryptableObjectPassthrough(boolean bl) {
        this.unsafeUndecryptableObjectPassthrough = bl;
        return this;
    }

    public Region getAwsKmsRegion() {
        return this.awsKmsRegion;
    }

    public void setAwsKmsRegion(Region region) {
        this.awsKmsRegion = region;
    }

    public CryptoConfigurationV2 withAwsKmsRegion(Region region) {
        this.awsKmsRegion = region;
        return this;
    }

    public CryptoConfigurationV2 withRangeGetMode(CryptoRangeGetMode cryptoRangeGetMode) {
        if (cryptoRangeGetMode == null) {
            cryptoRangeGetMode = CryptoRangeGetMode.DISABLED;
        }
        this.rangeGetMode = cryptoRangeGetMode;
        return this;
    }

    public void setRangeGetMode(CryptoRangeGetMode cryptoRangeGetMode) {
        this.withRangeGetMode(cryptoRangeGetMode);
    }

    public CryptoRangeGetMode getRangeGetMode() {
        return this.rangeGetMode;
    }

    private void checkCryptoMode(CryptoMode cryptoMode) {
        boolean bl;
        if (cryptoMode == CryptoMode.EncryptionOnly) {
            throw new UnsupportedOperationException("CryptoMode.EncryptionOnly is not allowed in this configuration");
        }
        boolean bl2 = cryptoMode == CryptoMode.AuthenticatedEncryption || cryptoMode == CryptoMode.StrictAuthenticatedEncryption;
        boolean bl3 = bl = this.cryptoProvider != null && this.alwaysUseCryptoProvider;
        if (bl2 && !bl) {
            this.checkBountyCastle();
        }
    }

    private void checkBountyCastle() {
        if (!CryptoRuntime.isBouncyCastleAvailable()) {
            CryptoRuntime.enableBouncyCastle();
            if (!CryptoRuntime.isBouncyCastleAvailable()) {
                throw new UnsupportedOperationException("The Bouncy castle library jar is required on the classpath to enable authenticated encryption");
            }
        }
        if (!CryptoRuntime.isAesGcmAvailable()) {
            throw new UnsupportedOperationException("A more recent version of Bouncy castle is required for authenticated encryption.");
        }
    }

    public boolean isReadOnly() {
        return false;
    }

    public CryptoConfigurationV2 readOnly() {
        if (this.isReadOnly()) {
            return this;
        }
        return this.copyTo(new ReadOnly());
    }

    public CryptoConfigurationV2 clone() {
        return this.copyTo(new CryptoConfigurationV2());
    }

    private CryptoConfigurationV2 copyTo(CryptoConfigurationV2 cryptoConfigurationV2) {
        cryptoConfigurationV2.cryptoMode = this.cryptoMode;
        cryptoConfigurationV2.storageMode = this.storageMode;
        cryptoConfigurationV2.cryptoProvider = this.cryptoProvider;
        cryptoConfigurationV2.alwaysUseCryptoProvider = this.alwaysUseCryptoProvider;
        cryptoConfigurationV2.secureRandom = this.secureRandom;
        cryptoConfigurationV2.unsafeUndecryptableObjectPassthrough = this.unsafeUndecryptableObjectPassthrough;
        cryptoConfigurationV2.awsKmsRegion = this.awsKmsRegion;
        cryptoConfigurationV2.rangeGetMode = this.rangeGetMode;
        return cryptoConfigurationV2;
    }

    private static final class ReadOnly
    extends CryptoConfigurationV2 {
        private ReadOnly() {
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public void setStorageMode(CryptoStorageMode cryptoStorageMode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CryptoConfigurationV2 withStorageMode(CryptoStorageMode cryptoStorageMode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCryptoProvider(Provider provider) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CryptoConfigurationV2 withCryptoProvider(Provider provider) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAlwaysUseCryptoProvider(boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CryptoConfigurationV2 withAlwaysUseCryptoProvider(boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSecureRandom(SecureRandom secureRandom) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CryptoConfigurationV2 withSecureRandom(SecureRandom secureRandom) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCryptoMode(CryptoMode cryptoMode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CryptoConfigurationV2 withCryptoMode(CryptoMode cryptoMode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setUnsafeUndecryptableObjectPassthrough(boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CryptoConfigurationV2 withUnsafeUndecryptableObjectPassthrough(boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAwsKmsRegion(Region region) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CryptoConfigurationV2 withAwsKmsRegion(Region region) {
            throw new UnsupportedOperationException();
        }
    }
}

