/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.s3.model.ExpectedBucketOwnerRequest;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CompleteMultipartUploadRequest
extends AmazonWebServiceRequest
implements ExpectedBucketOwnerRequest,
Serializable {
    private String bucketName;
    private String key;
    private String uploadId;
    private List<PartETag> partETags = new ArrayList<PartETag>();
    private boolean isRequesterPays;
    private String expectedBucketOwner;

    public CompleteMultipartUploadRequest() {
    }

    public CompleteMultipartUploadRequest(String string, String string2, String string3, List<PartETag> list) {
        this.bucketName = string;
        this.key = string2;
        this.uploadId = string3;
        this.partETags = list;
    }

    @Override
    public String getExpectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    @Override
    public CompleteMultipartUploadRequest withExpectedBucketOwner(String string) {
        this.expectedBucketOwner = string;
        return this;
    }

    @Override
    public void setExpectedBucketOwner(String string) {
        this.withExpectedBucketOwner(string);
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String string) {
        this.bucketName = string;
    }

    public CompleteMultipartUploadRequest withBucketName(String string) {
        this.bucketName = string;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public CompleteMultipartUploadRequest withKey(String string) {
        this.key = string;
        return this;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setUploadId(String string) {
        this.uploadId = string;
    }

    public CompleteMultipartUploadRequest withUploadId(String string) {
        this.uploadId = string;
        return this;
    }

    public List<PartETag> getPartETags() {
        return this.partETags;
    }

    public void setPartETags(List<PartETag> list) {
        this.partETags = list;
    }

    public CompleteMultipartUploadRequest withPartETags(List<PartETag> list) {
        this.setPartETags(list);
        return this;
    }

    public CompleteMultipartUploadRequest withPartETags(UploadPartResult ... uploadPartResultArray) {
        for (UploadPartResult uploadPartResult : uploadPartResultArray) {
            this.partETags.add(new PartETag(uploadPartResult.getPartNumber(), uploadPartResult.getETag()));
        }
        return this;
    }

    public CompleteMultipartUploadRequest withPartETags(Collection<UploadPartResult> collection) {
        for (UploadPartResult uploadPartResult : collection) {
            this.partETags.add(new PartETag(uploadPartResult.getPartNumber(), uploadPartResult.getETag()));
        }
        return this;
    }

    public boolean isRequesterPays() {
        return this.isRequesterPays;
    }

    public void setRequesterPays(boolean bl) {
        this.isRequesterPays = bl;
    }

    public CompleteMultipartUploadRequest withRequesterPays(boolean bl) {
        this.setRequesterPays(bl);
        return this;
    }
}

