/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.services.s3.model.FileHeaderInfo;
import java.io.Serializable;

public class CSVInput
implements Serializable,
Cloneable {
    private String fileHeaderInfo;
    private String comments;
    private String quoteEscapeCharacter;
    private String recordDelimiter;
    private String fieldDelimiter;
    private String quoteCharacter;
    private Boolean allowQuotedRecordDelimiter;

    public String getFileHeaderInfo() {
        return this.fileHeaderInfo;
    }

    public void setFileHeaderInfo(String string) {
        this.fileHeaderInfo = string;
    }

    public CSVInput withFileHeaderInfo(String string) {
        this.setFileHeaderInfo(string);
        return this;
    }

    public void setFileHeaderInfo(FileHeaderInfo fileHeaderInfo) {
        this.setFileHeaderInfo(fileHeaderInfo == null ? null : fileHeaderInfo.toString());
    }

    public CSVInput withFileHeaderInfo(FileHeaderInfo fileHeaderInfo) {
        this.setFileHeaderInfo(fileHeaderInfo);
        return this;
    }

    public Character getComments() {
        return this.stringToChar(this.comments);
    }

    public String getCommentsAsString() {
        return this.comments;
    }

    public void setComments(String string) {
        this.validateNotEmpty(string, "comments");
        this.comments = string;
    }

    public CSVInput withComments(String string) {
        this.setComments(string);
        return this;
    }

    public void setComments(Character c) {
        this.setComments(this.charToString(c));
    }

    public CSVInput withComments(Character c) {
        this.setComments(c);
        return this;
    }

    public Character getQuoteEscapeCharacter() {
        return this.stringToChar(this.quoteEscapeCharacter);
    }

    public String getQuoteEscapeCharacterAsString() {
        return this.quoteEscapeCharacter;
    }

    public void setQuoteEscapeCharacter(String string) {
        this.validateNotEmpty(string, "quoteEscapeCharacter");
        this.quoteEscapeCharacter = string;
    }

    public CSVInput withQuoteEscapeCharacter(String string) {
        this.setQuoteEscapeCharacter(string);
        return this;
    }

    public void setQuoteEscapeCharacter(Character c) {
        this.setQuoteEscapeCharacter(this.charToString(c));
    }

    public CSVInput withQuoteEscapeCharacter(Character c) {
        this.setQuoteEscapeCharacter(c);
        return this;
    }

    public Character getRecordDelimiter() {
        return this.stringToChar(this.recordDelimiter);
    }

    public String getRecordDelimiterAsString() {
        return this.recordDelimiter;
    }

    public void setRecordDelimiter(String string) {
        this.validateNotEmpty(string, "recordDelimiter");
        this.recordDelimiter = string;
    }

    public CSVInput withRecordDelimiter(String string) {
        this.setRecordDelimiter(string);
        return this;
    }

    public void setRecordDelimiter(Character c) {
        this.setRecordDelimiter(this.charToString(c));
    }

    public CSVInput withRecordDelimiter(Character c) {
        this.setRecordDelimiter(c);
        return this;
    }

    public Character getFieldDelimiter() {
        return this.stringToChar(this.fieldDelimiter);
    }

    public String getFieldDelimiterAsString() {
        return this.fieldDelimiter;
    }

    public void setFieldDelimiter(String string) {
        this.validateNotEmpty(string, "fieldDelimiter");
        this.fieldDelimiter = string;
    }

    public CSVInput withFieldDelimiter(String string) {
        this.setFieldDelimiter(string);
        return this;
    }

    public void setFieldDelimiter(Character c) {
        this.setFieldDelimiter(this.charToString(c));
    }

    public CSVInput withFieldDelimiter(Character c) {
        this.setFieldDelimiter(c);
        return this;
    }

    public Character getQuoteCharacter() {
        return this.stringToChar(this.quoteCharacter);
    }

    public String getQuoteCharacterAsString() {
        return this.quoteCharacter;
    }

    public void setQuoteCharacter(String string) {
        this.validateNotEmpty(string, "quoteCharacter");
        this.quoteCharacter = string;
    }

    public CSVInput withQuoteCharacter(String string) {
        this.setQuoteCharacter(string);
        return this;
    }

    public void setQuoteCharacter(Character c) {
        this.setQuoteCharacter(this.charToString(c));
    }

    public CSVInput withQuoteCharacter(Character c) {
        this.setQuoteCharacter(c);
        return this;
    }

    public Boolean getAllowQuotedRecordDelimiter() {
        return this.allowQuotedRecordDelimiter;
    }

    public void setAllowQuotedRecordDelimiter(Boolean bl) {
        this.allowQuotedRecordDelimiter = bl;
    }

    public CSVInput withAllowQuotedRecordDelimiter(Boolean bl) {
        this.setAllowQuotedRecordDelimiter(bl);
        return this;
    }

    private String charToString(Character c) {
        return c == null ? null : c.toString();
    }

    private Character stringToChar(String string) {
        return string == null ? null : Character.valueOf(string.charAt(0));
    }

    private void validateNotEmpty(String string, String string2) {
        if ("".equals(string)) {
            throw new IllegalArgumentException(string2 + " must not be empty-string.");
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof CSVInput)) {
            return false;
        }
        CSVInput cSVInput = (CSVInput)object;
        if (cSVInput.getFileHeaderInfo() == null ^ this.getFileHeaderInfo() == null) {
            return false;
        }
        if (cSVInput.getFileHeaderInfo() != null && !cSVInput.getFileHeaderInfo().equals(this.getFileHeaderInfo())) {
            return false;
        }
        if (cSVInput.getQuoteEscapeCharacterAsString() == null ^ this.getQuoteEscapeCharacterAsString() == null) {
            return false;
        }
        if (cSVInput.getQuoteEscapeCharacterAsString() != null && !cSVInput.getQuoteEscapeCharacterAsString().equals(this.getQuoteEscapeCharacterAsString())) {
            return false;
        }
        if (cSVInput.getCommentsAsString() == null ^ this.getCommentsAsString() == null) {
            return false;
        }
        if (cSVInput.getCommentsAsString() != null && !cSVInput.getCommentsAsString().equals(this.getCommentsAsString())) {
            return false;
        }
        if (cSVInput.getRecordDelimiterAsString() == null ^ this.getRecordDelimiterAsString() == null) {
            return false;
        }
        if (cSVInput.getRecordDelimiterAsString() != null && !cSVInput.getRecordDelimiterAsString().equals(this.getRecordDelimiterAsString())) {
            return false;
        }
        if (cSVInput.getFieldDelimiterAsString() == null ^ this.getFieldDelimiterAsString() == null) {
            return false;
        }
        if (cSVInput.getFieldDelimiterAsString() != null && !cSVInput.getFieldDelimiterAsString().equals(this.getFieldDelimiterAsString())) {
            return false;
        }
        if (cSVInput.getQuoteCharacterAsString() == null ^ this.getQuoteCharacterAsString() == null) {
            return false;
        }
        if (cSVInput.getQuoteCharacterAsString() != null && !cSVInput.getQuoteCharacterAsString().equals(this.getQuoteCharacterAsString())) {
            return false;
        }
        return cSVInput.getAllowQuotedRecordDelimiter() == null || cSVInput.getAllowQuotedRecordDelimiter().equals(this.getAllowQuotedRecordDelimiter());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getFileHeaderInfo() == null ? 0 : this.getFileHeaderInfo().hashCode());
        n2 = 31 * n2 + (this.getCommentsAsString() == null ? 0 : this.getCommentsAsString().hashCode());
        n2 = 31 * n2 + (this.getQuoteEscapeCharacterAsString() == null ? 0 : this.getQuoteEscapeCharacterAsString().hashCode());
        n2 = 31 * n2 + (this.getRecordDelimiterAsString() == null ? 0 : this.getRecordDelimiterAsString().hashCode());
        n2 = 31 * n2 + (this.getFieldDelimiterAsString() == null ? 0 : this.getFieldDelimiterAsString().hashCode());
        n2 = 31 * n2 + (this.getQuoteCharacterAsString() != null ? this.getQuoteCharacterAsString().hashCode() : 0);
        n2 = 31 * n2 + (this.getAllowQuotedRecordDelimiter() == null ? 0 : this.getAllowQuotedRecordDelimiter().hashCode());
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getFileHeaderInfo() != null) {
            stringBuilder.append("FileHeaderInfo: ").append(this.getFileHeaderInfo()).append(",");
        }
        if (this.getCommentsAsString() != null) {
            stringBuilder.append("Comments: ").append(this.getCommentsAsString()).append(",");
        }
        if (this.getQuoteEscapeCharacterAsString() != null) {
            stringBuilder.append("QuoteEscapeCharacter: ").append(this.getQuoteEscapeCharacterAsString()).append(",");
        }
        if (this.getRecordDelimiterAsString() != null) {
            stringBuilder.append("RecordDelimiter: ").append(this.getRecordDelimiterAsString()).append(",");
        }
        if (this.getFieldDelimiterAsString() != null) {
            stringBuilder.append("FieldDelimiter: ").append(this.getFieldDelimiterAsString()).append(",");
        }
        if (this.getQuoteCharacterAsString() != null) {
            stringBuilder.append("QuoteCharacter: ").append(this.getQuoteCharacterAsString());
        }
        if (this.getAllowQuotedRecordDelimiter() != null) {
            stringBuilder.append("AllowQuotedRecordDelimiter: ").append(this.getAllowQuotedRecordDelimiter());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public CSVInput clone() {
        try {
            return (CSVInput)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", cloneNotSupportedException);
        }
    }
}

