/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.services.s3.model.AbortIncompleteMultipartUpload;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.model.lifecycle.LifecycleFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class BucketLifecycleConfiguration
implements Serializable {
    public static final String ENABLED = "Enabled";
    public static final String DISABLED = "Disabled";
    private List<Rule> rules;

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(List<Rule> list) {
        this.rules = list;
    }

    public BucketLifecycleConfiguration withRules(List<Rule> list) {
        this.setRules(list);
        return this;
    }

    public BucketLifecycleConfiguration withRules(Rule ... ruleArray) {
        this.setRules(Arrays.asList(ruleArray));
        return this;
    }

    public BucketLifecycleConfiguration(List<Rule> list) {
        this.rules = list;
    }

    public BucketLifecycleConfiguration() {
    }

    public static class NoncurrentVersionExpiration
    implements Serializable {
        private int days = -1;
        private int newerNoncurrentVersions = -1;

        public void setDays(int n) {
            this.days = n;
        }

        public int getDays() {
            return this.days;
        }

        public NoncurrentVersionExpiration withDays(int n) {
            this.days = n;
            return this;
        }

        public void setNewerNoncurrentVersions(int n) {
            this.newerNoncurrentVersions = n;
        }

        public int getNewerNoncurrentVersions() {
            return this.newerNoncurrentVersions;
        }

        public NoncurrentVersionExpiration withNewerNoncurrentVersions(int n) {
            this.newerNoncurrentVersions = n;
            return this;
        }
    }

    public static class NoncurrentVersionTransition
    implements Serializable {
        private int days = -1;
        private String storageClass;
        private int newerNoncurrentVersions = -1;

        public void setDays(int n) {
            this.days = n;
        }

        public int getDays() {
            return this.days;
        }

        public NoncurrentVersionTransition withDays(int n) {
            this.days = n;
            return this;
        }

        public void setStorageClass(StorageClass storageClass) {
            if (storageClass == null) {
                this.setStorageClass((String)null);
            } else {
                this.setStorageClass(storageClass.toString());
            }
        }

        public void setStorageClass(String string) {
            this.storageClass = string;
        }

        @Deprecated
        public StorageClass getStorageClass() {
            try {
                return StorageClass.fromValue(this.storageClass);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }

        public String getStorageClassAsString() {
            return this.storageClass;
        }

        public NoncurrentVersionTransition withStorageClass(StorageClass storageClass) {
            this.setStorageClass(storageClass);
            return this;
        }

        public NoncurrentVersionTransition withStorageClass(String string) {
            this.setStorageClass(string);
            return this;
        }

        public void setNewerNoncurrentVersions(int n) {
            this.newerNoncurrentVersions = n;
        }

        public int getNewerNoncurrentVersions() {
            return this.newerNoncurrentVersions;
        }

        public NoncurrentVersionTransition withNewerNoncurrentVersions(int n) {
            this.newerNoncurrentVersions = n;
            return this;
        }
    }

    public static class Transition
    implements Serializable {
        private int days = -1;
        private Date date;
        private String storageClass;

        public void setDays(int n) {
            this.days = n;
        }

        public int getDays() {
            return this.days;
        }

        public Transition withDays(int n) {
            this.days = n;
            return this;
        }

        public void setStorageClass(StorageClass storageClass) {
            if (storageClass == null) {
                this.setStorageClass((String)null);
            } else {
                this.setStorageClass(storageClass.toString());
            }
        }

        public void setStorageClass(String string) {
            this.storageClass = string;
        }

        @Deprecated
        public StorageClass getStorageClass() {
            try {
                return StorageClass.fromValue(this.storageClass);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }

        public String getStorageClassAsString() {
            return this.storageClass;
        }

        public Transition withStorageClass(StorageClass storageClass) {
            this.setStorageClass(storageClass);
            return this;
        }

        public Transition withStorageClass(String string) {
            this.setStorageClass(string);
            return this;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public Date getDate() {
            return this.date;
        }

        public Transition withDate(Date date) {
            this.date = date;
            return this;
        }
    }

    public static class Rule
    implements Serializable {
        private String id;
        private String prefix;
        private String status;
        private LifecycleFilter filter;
        private int expirationInDays = -1;
        private boolean expiredObjectDeleteMarker = false;
        private Date expirationDate;
        private List<Transition> transitions;
        private List<NoncurrentVersionTransition> noncurrentVersionTransitions;
        private NoncurrentVersionExpiration noncurrentVersionExpiration;
        private AbortIncompleteMultipartUpload abortIncompleteMultipartUpload;

        public void setId(String string) {
            this.id = string;
        }

        @Deprecated
        public void setPrefix(String string) {
            this.prefix = string;
        }

        public void setExpirationInDays(int n) {
            this.expirationInDays = n;
        }

        @Deprecated
        public void setNoncurrentVersionExpirationInDays(int n) {
            NoncurrentVersionExpiration noncurrentVersionExpiration = this.noncurrentVersionExpiration;
            if (noncurrentVersionExpiration != null) {
                noncurrentVersionExpiration.setDays(n);
            } else {
                this.noncurrentVersionExpiration = new NoncurrentVersionExpiration().withDays(n);
            }
        }

        public String getId() {
            return this.id;
        }

        public Rule withId(String string) {
            this.id = string;
            return this;
        }

        @Deprecated
        public String getPrefix() {
            return this.prefix;
        }

        @Deprecated
        public Rule withPrefix(String string) {
            this.prefix = string;
            return this;
        }

        public int getExpirationInDays() {
            return this.expirationInDays;
        }

        public Rule withExpirationInDays(int n) {
            this.expirationInDays = n;
            return this;
        }

        @Deprecated
        public int getNoncurrentVersionExpirationInDays() {
            NoncurrentVersionExpiration noncurrentVersionExpiration = this.noncurrentVersionExpiration;
            return noncurrentVersionExpiration != null ? noncurrentVersionExpiration.getDays() : -1;
        }

        @Deprecated
        public Rule withNoncurrentVersionExpirationInDays(int n) {
            this.setNoncurrentVersionExpirationInDays(n);
            return this;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String string) {
            this.status = string;
        }

        public Rule withStatus(String string) {
            this.setStatus(string);
            return this;
        }

        public void setExpirationDate(Date date) {
            this.expirationDate = date;
        }

        public Date getExpirationDate() {
            return this.expirationDate;
        }

        public Rule withExpirationDate(Date date) {
            this.expirationDate = date;
            return this;
        }

        @Deprecated
        public void setTransition(Transition transition) {
            this.setTransitions(Arrays.asList(transition));
        }

        @Deprecated
        public Transition getTransition() {
            List<Transition> list = this.getTransitions();
            return list != null && !list.isEmpty() ? list.get(list.size() - 1) : null;
        }

        @Deprecated
        public Rule withTransition(Transition transition) {
            this.setTransitions(Arrays.asList(transition));
            return this;
        }

        @Deprecated
        public void setNoncurrentVersionTransition(NoncurrentVersionTransition noncurrentVersionTransition) {
            this.setNoncurrentVersionTransitions(Arrays.asList(noncurrentVersionTransition));
        }

        @Deprecated
        public NoncurrentVersionTransition getNoncurrentVersionTransition() {
            List<NoncurrentVersionTransition> list = this.getNoncurrentVersionTransitions();
            return list != null && !list.isEmpty() ? list.get(list.size() - 1) : null;
        }

        @Deprecated
        public Rule withNoncurrentVersionTransition(NoncurrentVersionTransition noncurrentVersionTransition) {
            this.setNoncurrentVersionTransitions(Arrays.asList(noncurrentVersionTransition));
            return this;
        }

        public List<Transition> getTransitions() {
            return this.transitions;
        }

        public void setTransitions(List<Transition> list) {
            this.transitions = new ArrayList<Transition>(list);
        }

        public Rule withTransitions(List<Transition> list) {
            this.setTransitions(list);
            return this;
        }

        public Rule addTransition(Transition transition) {
            if (transition == null) {
                throw new IllegalArgumentException("Transition cannot be null.");
            }
            if (this.transitions == null) {
                this.transitions = new ArrayList<Transition>();
            }
            this.transitions.add(transition);
            return this;
        }

        public List<NoncurrentVersionTransition> getNoncurrentVersionTransitions() {
            return this.noncurrentVersionTransitions;
        }

        public void setNoncurrentVersionTransitions(List<NoncurrentVersionTransition> list) {
            this.noncurrentVersionTransitions = new ArrayList<NoncurrentVersionTransition>(list);
        }

        public Rule withNoncurrentVersionTransitions(List<NoncurrentVersionTransition> list) {
            this.setNoncurrentVersionTransitions(list);
            return this;
        }

        public Rule addNoncurrentVersionTransition(NoncurrentVersionTransition noncurrentVersionTransition) {
            if (noncurrentVersionTransition == null) {
                throw new IllegalArgumentException("NoncurrentVersionTransition cannot be null.");
            }
            if (this.noncurrentVersionTransitions == null) {
                this.noncurrentVersionTransitions = new ArrayList<NoncurrentVersionTransition>();
            }
            this.noncurrentVersionTransitions.add(noncurrentVersionTransition);
            return this;
        }

        public NoncurrentVersionExpiration getNoncurrentVersionExpiration() {
            return this.noncurrentVersionExpiration;
        }

        public void setNoncurrentVersionExpiration(NoncurrentVersionExpiration noncurrentVersionExpiration) {
            this.noncurrentVersionExpiration = noncurrentVersionExpiration;
        }

        public Rule withNoncurrentVersionExpiration(NoncurrentVersionExpiration noncurrentVersionExpiration) {
            this.setNoncurrentVersionExpiration(noncurrentVersionExpiration);
            return this;
        }

        public AbortIncompleteMultipartUpload getAbortIncompleteMultipartUpload() {
            return this.abortIncompleteMultipartUpload;
        }

        public void setAbortIncompleteMultipartUpload(AbortIncompleteMultipartUpload abortIncompleteMultipartUpload) {
            this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
        }

        public Rule withAbortIncompleteMultipartUpload(AbortIncompleteMultipartUpload abortIncompleteMultipartUpload) {
            this.setAbortIncompleteMultipartUpload(abortIncompleteMultipartUpload);
            return this;
        }

        public boolean isExpiredObjectDeleteMarker() {
            return this.expiredObjectDeleteMarker;
        }

        public void setExpiredObjectDeleteMarker(boolean bl) {
            this.expiredObjectDeleteMarker = bl;
        }

        public Rule withExpiredObjectDeleteMarker(boolean bl) {
            this.expiredObjectDeleteMarker = bl;
            return this;
        }

        public LifecycleFilter getFilter() {
            return this.filter;
        }

        public void setFilter(LifecycleFilter lifecycleFilter) {
            this.filter = lifecycleFilter;
        }

        public Rule withFilter(LifecycleFilter lifecycleFilter) {
            this.setFilter(lifecycleFilter);
            return this;
        }
    }
}

