/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.AmazonServiceException;
import java.io.Serializable;
import java.util.Map;

public class AmazonS3Exception
extends AmazonServiceException
implements Serializable {
    private static final long serialVersionUID = 7573680383273658477L;
    private String extendedRequestId;
    private String cloudFrontId;
    private Map<String, String> additionalDetails;
    private final String errorResponseXml;

    public AmazonS3Exception(String string) {
        super(string);
        this.errorResponseXml = null;
    }

    public AmazonS3Exception(String string, Exception exception) {
        super(string, exception);
        this.errorResponseXml = null;
    }

    public AmazonS3Exception(String string, String string2) {
        super(string);
        if (string2 == null) {
            throw new IllegalArgumentException("Error Response XML cannot be null");
        }
        this.errorResponseXml = string2;
    }

    public String getExtendedRequestId() {
        return this.extendedRequestId;
    }

    public void setExtendedRequestId(String string) {
        this.extendedRequestId = string;
    }

    public String getCloudFrontId() {
        return this.cloudFrontId;
    }

    public void setCloudFrontId(String string) {
        this.cloudFrontId = string;
    }

    public Map<String, String> getAdditionalDetails() {
        return this.additionalDetails;
    }

    public void setAdditionalDetails(Map<String, String> map) {
        this.additionalDetails = map;
    }

    @Override
    public String toString() {
        return super.toString() + ", S3 Extended Request ID: " + this.getExtendedRequestId();
    }

    @Override
    public String getMessage() {
        return this.getErrorMessage() + " (Service: " + this.getServiceName() + "; Status Code: " + this.getStatusCode() + "; Error Code: " + this.getErrorCode() + "; Request ID: " + this.getRequestId() + "; S3 Extended Request ID: " + this.getExtendedRequestId() + "; Proxy: " + this.getProxyHost() + ")";
    }

    public String getErrorResponseXml() {
        return this.errorResponseXml;
    }
}

