/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.iterable;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.util.Iterator;

public class S3Objects
implements Iterable<S3ObjectSummary> {
    private AmazonS3 s3;
    private String prefix = null;
    private String bucketName;
    private Integer batchSize = null;
    private String delimiter;
    private String marker;
    private String encodingType;
    private boolean requesterPays;

    private S3Objects(AmazonS3 amazonS3, String string) {
        this.s3 = amazonS3;
        this.bucketName = string;
    }

    public static S3Objects inBucket(AmazonS3 amazonS3, String string) {
        return new S3Objects(amazonS3, string);
    }

    public static S3Objects withPrefix(AmazonS3 amazonS3, String string, String string2) {
        S3Objects s3Objects = new S3Objects(amazonS3, string);
        s3Objects.prefix = string2;
        return s3Objects;
    }

    public S3Objects withBatchSize(int n) {
        this.batchSize = n;
        return this;
    }

    public void withRequesterPays(boolean bl) {
        this.requesterPays = bl;
    }

    public void withEncodingType(String string) {
        this.encodingType = string;
    }

    public void withMarker(String string) {
        this.marker = string;
    }

    public void withDelimiter(String string) {
        this.delimiter = string;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getMarker() {
        return this.marker;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public boolean isRequesterPays() {
        return this.requesterPays;
    }

    public AmazonS3 getS3() {
        return this.s3;
    }

    @Override
    public Iterator<S3ObjectSummary> iterator() {
        return new S3ObjectIterator();
    }

    private class S3ObjectIterator
    implements Iterator<S3ObjectSummary> {
        private ObjectListing currentListing = null;
        private Iterator<S3ObjectSummary> currentIterator = null;

        private S3ObjectIterator() {
        }

        @Override
        public boolean hasNext() {
            this.prepareCurrentListing();
            return this.currentIterator.hasNext();
        }

        @Override
        public S3ObjectSummary next() {
            this.prepareCurrentListing();
            return this.currentIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void prepareCurrentListing() {
            while (this.currentListing == null || !this.currentIterator.hasNext() && this.currentListing.isTruncated()) {
                if (this.currentListing == null) {
                    ListObjectsRequest listObjectsRequest = new ListObjectsRequest();
                    listObjectsRequest.setBucketName(S3Objects.this.getBucketName());
                    listObjectsRequest.setPrefix(S3Objects.this.getPrefix());
                    listObjectsRequest.setMaxKeys(S3Objects.this.getBatchSize());
                    listObjectsRequest.setDelimiter(S3Objects.this.getDelimiter());
                    listObjectsRequest.setMarker(S3Objects.this.getMarker());
                    listObjectsRequest.setEncodingType(S3Objects.this.getEncodingType());
                    listObjectsRequest.setRequesterPays(S3Objects.this.isRequesterPays());
                    this.currentListing = S3Objects.this.getS3().listObjects(listObjectsRequest);
                } else {
                    this.currentListing = S3Objects.this.getS3().listNextBatchOfObjects(this.currentListing);
                }
                this.currentIterator = this.currentListing.getObjectSummaries().iterator();
            }
        }
    }
}

