/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.eventstreaming;

import com.amazonaws.util.StringUtils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

final class Utils {
    private Utils() {
    }

    static int toIntExact(long l) {
        if ((long)((int)l) != l) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)l;
    }

    static long toUnsignedLong(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    static String readShortString(ByteBuffer byteBuffer) {
        int n = byteBuffer.get() & 0xFF;
        Utils.checkStringBounds(n, 255);
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return new String(byArray, StringUtils.UTF8);
    }

    static String readString(ByteBuffer byteBuffer) {
        int n = byteBuffer.getShort() & 0xFFFF;
        Utils.checkStringBounds(n, Short.MAX_VALUE);
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return new String(byArray, StringUtils.UTF8);
    }

    static byte[] readBytes(ByteBuffer byteBuffer) {
        int n = byteBuffer.getShort() & 0xFFFF;
        Utils.checkByteArrayBounds(n);
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return byArray;
    }

    static void writeShortString(DataOutputStream dataOutputStream, String string) throws IOException {
        byte[] byArray = string.getBytes(StringUtils.UTF8);
        Utils.checkStringBounds(byArray.length, 255);
        dataOutputStream.writeByte(byArray.length);
        dataOutputStream.write(byArray);
    }

    static void writeString(DataOutputStream dataOutputStream, String string) throws IOException {
        byte[] byArray = string.getBytes(StringUtils.UTF8);
        Utils.checkStringBounds(byArray.length, Short.MAX_VALUE);
        Utils.writeBytes(dataOutputStream, byArray);
    }

    static void writeBytes(DataOutputStream dataOutputStream, byte[] byArray) throws IOException {
        Utils.checkByteArrayBounds(byArray.length);
        dataOutputStream.writeShort((short)byArray.length);
        dataOutputStream.write(byArray);
    }

    private static void checkByteArrayBounds(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("Byte arrays may not be empty");
        }
        if (n > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Illegal byte array length: " + n);
        }
    }

    private static void checkStringBounds(int n, int n2) {
        if (n == 0) {
            throw new IllegalArgumentException("Strings may not be empty");
        }
        if (n > n2) {
            throw new IllegalArgumentException("Illegal string length: " + n);
        }
    }
}

