/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.eventstreaming;

import com.amazonaws.services.s3.internal.eventstreaming.HeaderType;
import com.amazonaws.services.s3.internal.eventstreaming.Utils;
import com.amazonaws.util.Base64;
import com.amazonaws.util.ValidationUtils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;
import java.util.UUID;
import org.joda.time.DateTime;

public abstract class HeaderValue {
    public static HeaderValue fromBoolean(boolean bl) {
        return new BooleanValue(bl);
    }

    public static HeaderValue fromByte(byte by) {
        return new ByteValue(by);
    }

    public static HeaderValue fromShort(short s2) {
        return new ShortValue(s2);
    }

    public static HeaderValue fromInteger(int n) {
        return new IntegerValue(n);
    }

    public static HeaderValue fromLong(long l) {
        return new LongValue(l);
    }

    public static HeaderValue fromByteArray(byte[] byArray) {
        return new ByteArrayValue(byArray);
    }

    public static HeaderValue fromByteBuffer(ByteBuffer byteBuffer) {
        byteBuffer = byteBuffer.duplicate();
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return HeaderValue.fromByteArray(byArray);
    }

    public static HeaderValue fromString(String string) {
        return new StringValue(string);
    }

    public static HeaderValue fromTimestamp(DateTime dateTime) {
        return new TimestampValue(dateTime);
    }

    public static HeaderValue fromDate(Date date) {
        return new TimestampValue(new DateTime(date));
    }

    public static HeaderValue fromUuid(UUID uUID) {
        return new UuidValue(uUID);
    }

    protected HeaderValue() {
    }

    public abstract HeaderType getType();

    public boolean getBoolean() {
        throw new IllegalStateException();
    }

    public byte getByte() {
        throw new IllegalStateException("Expected byte, but type was " + this.getType().name());
    }

    public short getShort() {
        throw new IllegalStateException("Expected short, but type was " + this.getType().name());
    }

    public int getInteger() {
        throw new IllegalStateException("Expected integer, but type was " + this.getType().name());
    }

    public long getLong() {
        throw new IllegalStateException("Expected long, but type was " + this.getType().name());
    }

    public byte[] getByteArray() {
        throw new IllegalStateException();
    }

    public final ByteBuffer getByteBuffer() {
        return ByteBuffer.wrap(this.getByteArray());
    }

    public String getString() {
        throw new IllegalStateException();
    }

    public DateTime getTimestamp() {
        throw new IllegalStateException("Expected timestamp, but type was " + this.getType().name());
    }

    public Date getDate() {
        return this.getTimestamp().toDate();
    }

    public UUID getUuid() {
        throw new IllegalStateException("Expected UUID, but type was " + this.getType().name());
    }

    void encode(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.getType().headerTypeId);
        this.encodeValue(dataOutputStream);
    }

    abstract void encodeValue(DataOutputStream var1) throws IOException;

    static HeaderValue decode(ByteBuffer byteBuffer) {
        HeaderType headerType = HeaderType.fromTypeId(byteBuffer.get());
        switch (headerType) {
            case TRUE: {
                return new BooleanValue(true);
            }
            case FALSE: {
                return new BooleanValue(false);
            }
            case BYTE: {
                return new ByteValue(byteBuffer.get());
            }
            case SHORT: {
                return new ShortValue(byteBuffer.getShort());
            }
            case INTEGER: {
                return HeaderValue.fromInteger(byteBuffer.getInt());
            }
            case LONG: {
                return new LongValue(byteBuffer.getLong());
            }
            case BYTE_ARRAY: {
                return HeaderValue.fromByteArray(Utils.readBytes(byteBuffer));
            }
            case STRING: {
                return HeaderValue.fromString(Utils.readString(byteBuffer));
            }
            case TIMESTAMP: {
                return TimestampValue.decode(byteBuffer);
            }
            case UUID: {
                return UuidValue.decode(byteBuffer);
            }
        }
        throw new IllegalStateException();
    }

    private static final class UuidValue
    extends HeaderValue {
        private final UUID value;

        private UuidValue(UUID uUID) {
            this.value = ValidationUtils.assertNotNull(uUID, "value");
        }

        static UuidValue decode(ByteBuffer byteBuffer) {
            long l = byteBuffer.getLong();
            long l2 = byteBuffer.getLong();
            return new UuidValue(new UUID(l, l2));
        }

        @Override
        public HeaderType getType() {
            return HeaderType.UUID;
        }

        @Override
        public UUID getUuid() {
            return this.value;
        }

        @Override
        void encodeValue(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeLong(this.value.getMostSignificantBits());
            dataOutputStream.writeLong(this.value.getLeastSignificantBits());
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            UuidValue uuidValue = (UuidValue)object;
            return this.value.equals(uuidValue.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return this.value.toString();
        }
    }

    private static final class TimestampValue
    extends HeaderValue {
        private final DateTime value;

        private TimestampValue(DateTime dateTime) {
            this.value = ValidationUtils.assertNotNull(dateTime, "value");
        }

        static TimestampValue decode(ByteBuffer byteBuffer) {
            long l = byteBuffer.getLong();
            return new TimestampValue(new DateTime(l));
        }

        @Override
        public HeaderType getType() {
            return HeaderType.TIMESTAMP;
        }

        @Override
        public DateTime getTimestamp() {
            return this.value;
        }

        @Override
        void encodeValue(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeLong(this.value.getMillis());
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            TimestampValue timestampValue = (TimestampValue)object;
            return this.value.equals(timestampValue.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return this.value.toString();
        }
    }

    private static final class StringValue
    extends HeaderValue {
        private final String value;

        private StringValue(String string) {
            this.value = ValidationUtils.assertNotNull(string, "value");
        }

        @Override
        public HeaderType getType() {
            return HeaderType.STRING;
        }

        @Override
        public String getString() {
            return this.value;
        }

        @Override
        void encodeValue(DataOutputStream dataOutputStream) throws IOException {
            Utils.writeString(dataOutputStream, this.value);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            StringValue stringValue = (StringValue)object;
            return this.value.equals(stringValue.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return '\"' + this.value + '\"';
        }
    }

    private static final class ByteArrayValue
    extends HeaderValue {
        private final byte[] value;

        private ByteArrayValue(byte[] byArray) {
            this.value = ValidationUtils.assertNotNull(byArray, "value");
        }

        @Override
        public HeaderType getType() {
            return HeaderType.BYTE_ARRAY;
        }

        @Override
        public byte[] getByteArray() {
            return this.value;
        }

        @Override
        void encodeValue(DataOutputStream dataOutputStream) throws IOException {
            Utils.writeBytes(dataOutputStream, this.value);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ByteArrayValue byteArrayValue = (ByteArrayValue)object;
            return Arrays.equals(this.value, byteArrayValue.value);
        }

        public int hashCode() {
            return Arrays.hashCode(this.value);
        }

        public String toString() {
            return Base64.encodeAsString(this.value);
        }
    }

    private static final class LongValue
    extends HeaderValue {
        private final long value;

        private LongValue(long l) {
            this.value = l;
        }

        @Override
        public HeaderType getType() {
            return HeaderType.LONG;
        }

        @Override
        public long getLong() {
            return this.value;
        }

        @Override
        void encodeValue(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeLong(this.value);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            LongValue longValue = (LongValue)object;
            return this.value == longValue.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static final class IntegerValue
    extends HeaderValue {
        private final int value;

        private IntegerValue(int n) {
            this.value = n;
        }

        @Override
        public HeaderType getType() {
            return HeaderType.INTEGER;
        }

        @Override
        public int getInteger() {
            return this.value;
        }

        @Override
        void encodeValue(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeInt(this.value);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            IntegerValue integerValue = (IntegerValue)object;
            return this.value == integerValue.value;
        }

        public int hashCode() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static final class ShortValue
    extends HeaderValue {
        private final short value;

        private ShortValue(short s2) {
            this.value = s2;
        }

        @Override
        public HeaderType getType() {
            return HeaderType.SHORT;
        }

        @Override
        public short getShort() {
            return this.value;
        }

        @Override
        void encodeValue(DataOutputStream dataOutputStream) {
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ShortValue shortValue = (ShortValue)object;
            return this.value == shortValue.value;
        }

        public int hashCode() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static final class ByteValue
    extends HeaderValue {
        private final byte value;

        private ByteValue(byte by) {
            this.value = by;
        }

        @Override
        public HeaderType getType() {
            return HeaderType.BYTE;
        }

        @Override
        public byte getByte() {
            return this.value;
        }

        @Override
        void encodeValue(DataOutputStream dataOutputStream) {
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ByteValue byteValue = (ByteValue)object;
            return this.value == byteValue.value;
        }

        public int hashCode() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static final class BooleanValue
    extends HeaderValue {
        private final boolean value;

        private BooleanValue(boolean bl) {
            this.value = bl;
        }

        @Override
        public HeaderType getType() {
            if (this.value) {
                return HeaderType.TRUE;
            }
            return HeaderType.FALSE;
        }

        @Override
        public boolean getBoolean() {
            return this.value;
        }

        @Override
        void encodeValue(DataOutputStream dataOutputStream) {
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            BooleanValue booleanValue = (BooleanValue)object;
            return this.value == booleanValue.value;
        }

        public int hashCode() {
            if (this.value) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

