/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto.keywrap;

import com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import com.amazonaws.services.s3.internal.crypto.keywrap.InternalKeyWrapAlgorithm;
import com.amazonaws.services.s3.internal.crypto.keywrap.KMSKeyWrapperContext;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import java.security.Provider;
import java.security.SecureRandom;

public class KeyWrapperContext {
    private final byte[] cekSecured;
    private final EncryptionMaterials materials;
    private final ContentCryptoScheme contentCryptoScheme;
    private final KMSKeyWrapperContext kmsKeyWrapperContext;
    private final InternalKeyWrapAlgorithm internalKeyWrapAlgorithm;
    private final Provider cryptoProvider;
    private final SecureRandom secureRandom;

    private KeyWrapperContext(Builder builder) {
        this.cekSecured = builder.cekSecured;
        this.internalKeyWrapAlgorithm = builder.internalKeyWrapAlgorithm;
        this.materials = builder.materials;
        this.contentCryptoScheme = builder.contentCryptoScheme;
        this.kmsKeyWrapperContext = builder.kmsKeyWrapperContext;
        this.cryptoProvider = builder.cryptoProvider;
        this.secureRandom = builder.secureRandom;
    }

    public static Builder builder() {
        return new Builder();
    }

    public byte[] cekSecured() {
        return this.cekSecured;
    }

    public InternalKeyWrapAlgorithm internalKeyWrapAlgorithm() {
        return this.internalKeyWrapAlgorithm;
    }

    public EncryptionMaterials materials() {
        return this.materials;
    }

    public ContentCryptoScheme contentCryptoScheme() {
        return this.contentCryptoScheme;
    }

    public KMSKeyWrapperContext kmsKeyWrapperContext() {
        return this.kmsKeyWrapperContext;
    }

    public Provider cryptoProvider() {
        return this.cryptoProvider;
    }

    public SecureRandom secureRandom() {
        return this.secureRandom;
    }

    public static class Builder {
        private byte[] cekSecured;
        private EncryptionMaterials materials;
        private ContentCryptoScheme contentCryptoScheme;
        private KMSKeyWrapperContext kmsKeyWrapperContext;
        private InternalKeyWrapAlgorithm internalKeyWrapAlgorithm;
        private Provider cryptoProvider;
        private SecureRandom secureRandom;

        public Builder cekSecured(byte[] byArray) {
            this.cekSecured = byArray;
            return this;
        }

        public Builder internalKeyWrapAlgorithm(InternalKeyWrapAlgorithm internalKeyWrapAlgorithm) {
            this.internalKeyWrapAlgorithm = internalKeyWrapAlgorithm;
            return this;
        }

        public Builder materials(EncryptionMaterials encryptionMaterials) {
            this.materials = encryptionMaterials;
            return this;
        }

        public Builder contentCryptoScheme(ContentCryptoScheme contentCryptoScheme) {
            this.contentCryptoScheme = contentCryptoScheme;
            return this;
        }

        public Builder kmsKeyWrapperContext(KMSKeyWrapperContext kMSKeyWrapperContext) {
            this.kmsKeyWrapperContext = kMSKeyWrapperContext;
            return this;
        }

        public Builder cryptoProvider(Provider provider) {
            this.cryptoProvider = provider;
            return this;
        }

        public Builder secureRandom(SecureRandom secureRandom) {
            this.secureRandom = secureRandom;
            return this;
        }

        public KeyWrapperContext build() {
            return new KeyWrapperContext(this);
        }
    }
}

