/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto.keywrap;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.kms.model.DecryptRequest;
import com.amazonaws.services.kms.model.DecryptResult;
import com.amazonaws.services.kms.model.EncryptRequest;
import com.amazonaws.services.kms.model.EncryptResult;
import com.amazonaws.services.s3.internal.crypto.keywrap.KMSKeyWrapperContext;
import com.amazonaws.services.s3.internal.crypto.keywrap.KeyWrapper;
import com.amazonaws.services.s3.model.KMSEncryptionMaterials;
import com.amazonaws.util.BinaryUtils;
import java.nio.ByteBuffer;
import java.security.Key;

public final class KMSKeyWrapper
implements KeyWrapper {
    private final KMSEncryptionMaterials encryptionMaterials;
    private final KMSKeyWrapperContext kmsKeyWrapperContext;

    private KMSKeyWrapper(Builder builder) {
        this.encryptionMaterials = this.validateNotNull(builder.encryptionMaterials, "encryptionMaterials");
        this.kmsKeyWrapperContext = this.validateNotNull(builder.kmsKeyWrapperContext, "kmsKeyWrapperContext");
    }

    public static Builder builder() {
        return new Builder();
    }

    public KMSEncryptionMaterials encryptionMaterials() {
        return this.encryptionMaterials;
    }

    public KMSKeyWrapperContext kmsKeyWrapperContext() {
        return this.kmsKeyWrapperContext;
    }

    @Override
    public byte[] unwrapCek(byte[] byArray, Key key) {
        DecryptRequest decryptRequest = new DecryptRequest().withKeyId(this.encryptionMaterials.getCustomerMasterKeyId()).withEncryptionContext(this.kmsKeyWrapperContext.kmsMaterialsDescription()).withCiphertextBlob(ByteBuffer.wrap(byArray));
        DecryptResult decryptResult = this.kmsKeyWrapperContext.kms().decrypt(decryptRequest);
        return BinaryUtils.copyAllBytesFrom(decryptResult.getPlaintext());
    }

    @Override
    public byte[] wrapCek(byte[] byArray, Key key) {
        Cloneable cloneable;
        EncryptRequest encryptRequest = new EncryptRequest().withEncryptionContext(this.kmsKeyWrapperContext.kmsMaterialsDescription()).withKeyId(this.encryptionMaterials.getCustomerMasterKeyId()).withPlaintext(ByteBuffer.wrap(byArray));
        if (this.kmsKeyWrapperContext.originalRequest() != null) {
            cloneable = this.kmsKeyWrapperContext.originalRequest();
            ((AmazonWebServiceRequest)encryptRequest.withGeneralProgressListener(((AmazonWebServiceRequest)cloneable).getGeneralProgressListener())).withRequestMetricCollector(((AmazonWebServiceRequest)cloneable).getRequestMetricCollector());
        }
        cloneable = this.kmsKeyWrapperContext.kms().encrypt(encryptRequest);
        return BinaryUtils.copyAllBytesFrom(((EncryptResult)cloneable).getCiphertextBlob());
    }

    private <T> T validateNotNull(T t2, String string) {
        if (t2 == null) {
            throw new NullPointerException("Error initializing KMSKeyWrapper: '" + string + "' cannot be null");
        }
        return t2;
    }

    public static final class Builder {
        private KMSEncryptionMaterials encryptionMaterials;
        private KMSKeyWrapperContext kmsKeyWrapperContext;

        private Builder() {
        }

        public Builder encryptionMaterials(KMSEncryptionMaterials kMSEncryptionMaterials) {
            this.encryptionMaterials = kMSEncryptionMaterials;
            return this;
        }

        public Builder kmsKeyWrapperContext(KMSKeyWrapperContext kMSKeyWrapperContext) {
            this.kmsKeyWrapperContext = kMSKeyWrapperContext;
            return this;
        }

        public KMSKeyWrapper build() {
            return new KMSKeyWrapper(this);
        }
    }
}

