/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto.keywrap;

import com.amazonaws.services.s3.internal.crypto.keywrap.CipherProvider;
import com.amazonaws.services.s3.internal.crypto.keywrap.KeyWrapper;
import com.amazonaws.util.Throwables;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;

public final class AesGcmKeyWrapper
implements KeyWrapper {
    private static final String CIPHER_ALGORITHM = "AES/GCM/NoPadding";
    private static final int IV_LENGTH_IN_BYTES = 12;
    private static final int TAG_LENGTH_IN_BYTES = 16;
    private static final int TAG_LENGTH_IN_BITS = 128;
    private final CipherProvider cipherProvider;
    private final SecureRandom secureRandom;
    private final String cekAlgorithm;

    private AesGcmKeyWrapper(Builder builder) {
        this.cipherProvider = this.validateNotNull(builder.cipherProvider, "cipherProvider");
        this.secureRandom = builder.secureRandom;
        this.cekAlgorithm = this.validateNotNull(builder.cekAlgorithm, "cekAlgorithm");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static String cipherAlgorithm() {
        return CIPHER_ALGORITHM;
    }

    public CipherProvider cipherProvider() {
        return this.cipherProvider;
    }

    public SecureRandom secureRandom() {
        return this.secureRandom;
    }

    public String cekAlgorithm() {
        return this.cekAlgorithm;
    }

    @Override
    public byte[] unwrapCek(byte[] byArray, Key key) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byte[] byArray2 = new byte[12];
        byte[] byArray3 = new byte[byArray.length - 12];
        byteBuffer.get(byArray2);
        byteBuffer.get(byArray3);
        Cipher cipher = this.cipherProvider.createCipher();
        GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(128, byArray2);
        try {
            cipher.init(2, key, gCMParameterSpec);
            cipher.updateAAD(this.cekAlgorithm.getBytes(StandardCharsets.UTF_8));
            return cipher.doFinal(byArray3);
        }
        catch (Exception exception) {
            throw Throwables.failure(exception, "An exception was thrown when attempting to decrypt the Content Encryption Key");
        }
    }

    @Override
    public byte[] wrapCek(byte[] byArray, Key key) {
        if (this.secureRandom == null) {
            throw new NullPointerException("Error initializing AesGcmKeyWrapper for wrapping: 'secureRandom' cannot be null");
        }
        Cipher cipher = this.cipherProvider.createCipher();
        byte[] byArray2 = new byte[12];
        this.secureRandom.nextBytes(byArray2);
        GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(128, byArray2);
        try {
            cipher.init(1, key, gCMParameterSpec, this.secureRandom);
            cipher.updateAAD(this.cekAlgorithm.getBytes(StandardCharsets.UTF_8));
            return AesGcmKeyWrapper.concat(cipher.getIV(), cipher.doFinal(byArray));
        }
        catch (Exception exception) {
            throw Throwables.failure(exception, "An exception was thrown when attempting to encrypt the Content Encryption Key");
        }
    }

    private <T> T validateNotNull(T t2, String string) {
        if (t2 == null) {
            throw new NullPointerException("Error initializing AesGcmKeyWrapper: '" + string + "' cannot be null");
        }
        return t2;
    }

    private static byte[] concat(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static final class Builder {
        private CipherProvider cipherProvider;
        private SecureRandom secureRandom;
        private String cekAlgorithm;

        private Builder() {
        }

        public Builder cipherProvider(CipherProvider cipherProvider) {
            this.cipherProvider = cipherProvider;
            return this;
        }

        public Builder secureRandom(SecureRandom secureRandom) {
            this.secureRandom = secureRandom;
            return this;
        }

        public Builder cekAlgorithm(String string) {
            this.cekAlgorithm = string;
            return this;
        }

        public AesGcmKeyWrapper build() {
            return new AesGcmKeyWrapper(this);
        }
    }
}

