/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PresignedUrlDownloadRequest;
import com.amazonaws.services.s3.model.PresignedUrlUploadRequest;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.UploadPartRequest;

public class SkipMd5CheckStrategy {
    public static final String DISABLE_GET_OBJECT_MD5_VALIDATION_PROPERTY = "com.amazonaws.services.s3.disableGetObjectMD5Validation";
    public static final String DISABLE_PUT_OBJECT_MD5_VALIDATION_PROPERTY = "com.amazonaws.services.s3.disablePutObjectMD5Validation";
    public static final SkipMd5CheckStrategy INSTANCE = new SkipMd5CheckStrategy();

    private SkipMd5CheckStrategy() {
    }

    public boolean skipClientSideValidationPerGetResponse(ObjectMetadata objectMetadata) {
        if (this.isGetObjectMd5ValidationDisabledByProperty()) {
            return true;
        }
        return this.skipClientSideValidationPerResponse(objectMetadata);
    }

    public boolean skipClientSideValidationPerPutResponse(ObjectMetadata objectMetadata) {
        if (this.isPutObjectMd5ValidationDisabledByProperty()) {
            return true;
        }
        return this.skipClientSideValidationPerResponse(objectMetadata);
    }

    public boolean skipClientSideValidationPerUploadPartResponse(ObjectMetadata objectMetadata) {
        return this.skipClientSideValidationPerPutResponse(objectMetadata);
    }

    public boolean skipClientSideValidation(GetObjectRequest getObjectRequest, ObjectMetadata objectMetadata) {
        return this.skipClientSideValidationPerRequest(getObjectRequest) || this.skipClientSideValidationPerGetResponse(objectMetadata);
    }

    public boolean skipClientSideValidation(PresignedUrlDownloadRequest presignedUrlDownloadRequest, ObjectMetadata objectMetadata) {
        return this.skipClientSideValidationPerRequest(presignedUrlDownloadRequest) || this.skipClientSideValidationPerGetResponse(objectMetadata);
    }

    public boolean skipClientSideValidationPerRequest(PutObjectRequest putObjectRequest) {
        if (this.isPutObjectMd5ValidationDisabledByProperty()) {
            return true;
        }
        return this.putRequestInvolvesSse(putObjectRequest) || this.metadataInvolvesSse(putObjectRequest.getMetadata());
    }

    public boolean skipClientSideValidationPerRequest(UploadPartRequest uploadPartRequest) {
        if (this.isPutObjectMd5ValidationDisabledByProperty()) {
            return true;
        }
        return uploadPartRequest.getSSECustomerKey() != null;
    }

    public boolean skipServerSideValidation(PutObjectRequest putObjectRequest) {
        return this.isPutObjectMd5ValidationDisabledByProperty();
    }

    public boolean skipServerSideValidation(UploadPartRequest uploadPartRequest) {
        return this.isPutObjectMd5ValidationDisabledByProperty();
    }

    public boolean skipClientSideValidationPerRequest(GetObjectRequest getObjectRequest) {
        if (this.isGetObjectMd5ValidationDisabledByProperty()) {
            return true;
        }
        if (getObjectRequest.getRange() != null) {
            return true;
        }
        return getObjectRequest.getSSECustomerKey() != null;
    }

    public boolean skipClientSideValidationPerRequest(PresignedUrlDownloadRequest presignedUrlDownloadRequest) {
        if (this.isGetObjectMd5ValidationDisabledByProperty()) {
            return true;
        }
        return presignedUrlDownloadRequest.getRange() != null;
    }

    public boolean skipClientSideValidationPerRequest(PresignedUrlUploadRequest presignedUrlUploadRequest) {
        if (this.isPutObjectMd5ValidationDisabledByProperty()) {
            return true;
        }
        return this.metadataInvolvesSse(presignedUrlUploadRequest.getMetadata());
    }

    private boolean skipClientSideValidationPerResponse(ObjectMetadata objectMetadata) {
        if (objectMetadata == null) {
            return true;
        }
        if (objectMetadata.getETag() == null || SkipMd5CheckStrategy.isMultipartUploadETag(objectMetadata.getETag())) {
            return true;
        }
        return this.metadataInvolvesSse(objectMetadata);
    }

    private boolean isGetObjectMd5ValidationDisabledByProperty() {
        return System.getProperty(DISABLE_GET_OBJECT_MD5_VALIDATION_PROPERTY) != null;
    }

    private boolean isPutObjectMd5ValidationDisabledByProperty() {
        return System.getProperty(DISABLE_PUT_OBJECT_MD5_VALIDATION_PROPERTY) != null;
    }

    private boolean metadataInvolvesSse(ObjectMetadata objectMetadata) {
        if (objectMetadata == null) {
            return false;
        }
        return SkipMd5CheckStrategy.containsNonNull(objectMetadata.getSSECustomerAlgorithm(), objectMetadata.getSSECustomerKeyMd5(), objectMetadata.getSSEAwsKmsKeyId());
    }

    private boolean putRequestInvolvesSse(PutObjectRequest putObjectRequest) {
        return SkipMd5CheckStrategy.containsNonNull(putObjectRequest.getSSECustomerKey(), putObjectRequest.getSSEAwsKeyManagementParams());
    }

    private static boolean isMultipartUploadETag(String string) {
        return string.contains("-");
    }

    private static boolean containsNonNull(Object ... objectArray) {
        for (Object object : objectArray) {
            if (object == null) continue;
            return true;
        }
        return false;
    }
}

