/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.internal.FileLocks;
import com.amazonaws.services.s3.internal.RequestCopyUtils;
import com.amazonaws.services.s3.internal.SkipMd5CheckStrategy;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.transfer.exception.FileLockException;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.Md5Utils;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.ValidationUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLProtocolException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceUtils {
    private static final Log LOG = LogFactory.getLog(ServiceUtils.class);
    public static final boolean APPEND_MODE = true;
    public static final boolean OVERWRITE_MODE = false;
    private static final SkipMd5CheckStrategy skipMd5CheckStrategy = SkipMd5CheckStrategy.INSTANCE;
    @Deprecated
    protected static final DateUtils dateUtils = new DateUtils();

    public static Date parseIso8601Date(String string) {
        return DateUtils.parseISO8601Date(string);
    }

    public static String formatIso8601Date(Date date) {
        return DateUtils.formatISO8601Date(date);
    }

    public static Date parseRfc822Date(String string) {
        if (StringUtils.isNullOrEmpty(string)) {
            return null;
        }
        return DateUtils.parseRFC822Date(string);
    }

    public static String formatRfc822Date(Date date) {
        return DateUtils.formatRFC822Date(date);
    }

    public static byte[] toByteArray(String string) {
        return string.getBytes(StringUtils.UTF8);
    }

    public static String removeQuotes(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).startsWith("\"")) {
            string = string.substring(1);
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    @Deprecated
    public static URL convertRequestToUrl(Request<?> request) {
        return ServiceUtils.convertRequestToUrl(request, false);
    }

    @Deprecated
    public static URL convertRequestToUrl(Request<?> request, boolean bl) {
        return ServiceUtils.convertRequestToUrl(request, bl, true);
    }

    public static URL convertRequestToUrl(Request<?> request, boolean bl, boolean bl2) {
        String string;
        String string2 = string = bl2 ? SdkHttpUtils.urlEncode(request.getResourcePath(), true) : request.getResourcePath();
        if (bl && string.startsWith("/")) {
            string = string.substring(1);
        }
        String string3 = "/" + string;
        string3 = string3.replaceAll("(?<=/)/", "%2F");
        StringBuilder stringBuilder = new StringBuilder(request.getEndpoint().toString());
        stringBuilder.append(string3);
        StringBuilder stringBuilder2 = new StringBuilder();
        Map<String, List<String>> map = request.getParameters();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            for (String string4 : entry.getValue()) {
                stringBuilder2 = stringBuilder2.length() > 0 ? stringBuilder2.append("&") : stringBuilder2.append("?");
                stringBuilder2.append(entry.getKey()).append("=").append(SdkHttpUtils.urlEncode(string4, false));
            }
        }
        stringBuilder.append(stringBuilder2.toString());
        try {
            return new URL(stringBuilder.toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new SdkClientException("Unable to convert request to well formed URL: " + malformedURLException.getMessage(), malformedURLException);
        }
    }

    public static String join(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : list) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
            bl = false;
        }
        return stringBuilder.toString();
    }

    public static void downloadObjectToFile(S3Object s3Object, File file, boolean bl, boolean bl2) {
        ServiceUtils.downloadToFile(s3Object, file, bl, bl2, -1L);
    }

    public static void downloadToFile(S3Object s3Object, File file, boolean bl, boolean bl2, long l) {
        Object object;
        ServiceUtils.createParentDirectoryIfNecessary(file);
        if (!FileLocks.lock(file)) {
            throw new FileLockException("Fail to lock " + file + " for appendData=" + bl2);
        }
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int n;
            long l2 = file.length();
            if (bl2 && l2 != l) {
                throw new IllegalStateException("Expected file length to append is " + l + " but actual length is " + l2 + " for file " + file);
            }
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file, bl2));
            object = new byte[10240];
            while ((n = s3Object.getObjectContent().read((byte[])object)) > -1) {
                ((OutputStream)bufferedOutputStream).write((byte[])object, 0, n);
            }
        }
        catch (IOException iOException) {
            try {
                s3Object.getObjectContent().abort();
                throw new SdkClientException("Unable to store object contents to disk: " + iOException.getMessage(), iOException);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedOutputStream, LOG);
                FileLocks.unlock(file);
                IOUtils.closeQuietly(s3Object.getObjectContent(), LOG);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(bufferedOutputStream, LOG);
        FileLocks.unlock(file);
        IOUtils.closeQuietly(s3Object.getObjectContent(), LOG);
        if (bl) {
            byte[] byArray = null;
            byte[] byArray2 = null;
            try {
                object = s3Object.getObjectMetadata();
                if (!skipMd5CheckStrategy.skipClientSideValidationPerGetResponse((ObjectMetadata)object)) {
                    byArray = Md5Utils.computeMD5Hash(new FileInputStream(file));
                    byArray2 = BinaryUtils.fromHex(((ObjectMetadata)object).getETag());
                }
            }
            catch (Exception exception) {
                LOG.warn("Unable to calculate MD5 hash to validate download: " + exception.getMessage(), exception);
            }
            if (byArray != null && byArray2 != null && !Arrays.equals(byArray, byArray2)) {
                throw new SdkClientException("Unable to verify integrity of data download.  Client calculated content hash didn't match hash calculated by Amazon S3.  The data stored in '" + file.getAbsolutePath() + "' may be corrupt.");
            }
        }
    }

    public static void createParentDirectoryIfNecessary(File file) {
        File file2 = file.getParentFile();
        if (file2 == null || file2.mkdirs() || file2.exists()) {
            return;
        }
        throw new SdkClientException("Unable to create directory in the path: " + file2.getAbsolutePath());
    }

    public static S3Object retryableDownloadS3ObjectToFile(File file, RetryableS3DownloadTask retryableS3DownloadTask, boolean bl) {
        S3Object s3Object;
        boolean bl2;
        boolean bl3 = false;
        do {
            bl2 = false;
            s3Object = retryableS3DownloadTask.getS3ObjectStream();
            if (s3Object == null) {
                return null;
            }
            try {
                ServiceUtils.downloadObjectToFile(s3Object, file, retryableS3DownloadTask.needIntegrityCheck(), bl);
            }
            catch (SdkClientException sdkClientException) {
                if (!sdkClientException.isRetryable()) {
                    s3Object.getObjectContent().abort();
                    throw sdkClientException;
                }
                if (sdkClientException.getCause() instanceof SocketException || sdkClientException.getCause() instanceof SSLProtocolException) {
                    throw sdkClientException;
                }
                bl2 = true;
                if (bl3) {
                    s3Object.getObjectContent().abort();
                    throw sdkClientException;
                }
                LOG.info("Retry the download of object " + s3Object.getKey() + " (bucket " + s3Object.getBucketName() + ")", sdkClientException);
                bl3 = true;
            }
        } while (bl2);
        return s3Object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void appendFile(File file, File file2) {
        ValidationUtils.assertNotNull(file2, "destFile");
        ValidationUtils.assertNotNull(file, "sourceFile");
        if (!FileLocks.lock(file)) {
            throw new FileLockException("Fail to lock " + file);
        }
        if (!FileLocks.lock(file2)) {
            throw new FileLockException("Fail to lock " + file2);
        }
        FileChannel fileChannel = null;
        FileChannel fileChannel2 = null;
        try {
            fileChannel = new FileInputStream(file).getChannel();
            fileChannel2 = new FileOutputStream(file2, true).getChannel();
            long l = fileChannel.size();
            long l2 = 0x2000000L;
            for (long i = 0L; i < l; i += fileChannel.transferTo(i, 0x2000000L, fileChannel2)) {
            }
        }
        catch (IOException iOException) {
            try {
                throw new SdkClientException("Unable to append file " + file.getAbsolutePath() + "to destination file " + file2.getAbsolutePath() + "\n" + iOException.getMessage(), iOException);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileChannel2, LOG);
                IOUtils.closeQuietly(fileChannel, LOG);
                FileLocks.unlock(file);
                FileLocks.unlock(file2);
                try {
                    if (file.delete()) throw throwable;
                    LOG.warn("Failed to delete file " + file.getAbsolutePath());
                    throw throwable;
                }
                catch (SecurityException securityException) {
                    LOG.warn("Security manager denied delete access to file " + file.getAbsolutePath());
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly(fileChannel2, LOG);
        IOUtils.closeQuietly(fileChannel, LOG);
        FileLocks.unlock(file);
        FileLocks.unlock(file2);
        try {
            if (file.delete()) return;
            LOG.warn("Failed to delete file " + file.getAbsolutePath());
            return;
        }
        catch (SecurityException securityException) {
            LOG.warn("Security manager denied delete access to file " + file.getAbsolutePath());
            return;
        }
    }

    public static boolean isS3USStandardEndpoint(String string) {
        return string.endsWith("s3.amazonaws.com");
    }

    public static boolean isS3USEastEndpiont(String string) {
        return ServiceUtils.isS3USStandardEndpoint(string) || string.endsWith("s3-external-1.amazonaws.com");
    }

    public static boolean isS3AccelerateEndpoint(String string) {
        return string.endsWith("s3-accelerate.amazonaws.com") || string.endsWith("s3-accelerate.dualstack.amazonaws.com");
    }

    public static Integer getPartCount(GetObjectRequest getObjectRequest, AmazonS3 amazonS3) {
        ValidationUtils.assertNotNull(amazonS3, "S3 client");
        ValidationUtils.assertNotNull(getObjectRequest, "GetObjectRequest");
        GetObjectMetadataRequest getObjectMetadataRequest = RequestCopyUtils.createGetObjectMetadataRequestFrom(getObjectRequest).withPartNumber(1);
        return amazonS3.getObjectMetadata(getObjectMetadataRequest).getPartCount();
    }

    @SdkInternalApi
    public static long getPartSize(GetObjectRequest getObjectRequest, AmazonS3 amazonS3, int n) {
        ValidationUtils.assertNotNull(amazonS3, "S3 client");
        ValidationUtils.assertNotNull(getObjectRequest, "GetObjectRequest");
        GetObjectMetadataRequest getObjectMetadataRequest = RequestCopyUtils.createGetObjectMetadataRequestFrom(getObjectRequest).withPartNumber(n);
        return amazonS3.getObjectMetadata(getObjectMetadataRequest).getContentLength();
    }

    public static long getLastByteInPart(AmazonS3 amazonS3, GetObjectRequest getObjectRequest, Integer n) {
        ValidationUtils.assertNotNull(amazonS3, "S3 client");
        ValidationUtils.assertNotNull(getObjectRequest, "GetObjectRequest");
        ValidationUtils.assertNotNull(n, "partNumber");
        GetObjectMetadataRequest getObjectMetadataRequest = RequestCopyUtils.createGetObjectMetadataRequestFrom(getObjectRequest).withPartNumber(n);
        ObjectMetadata objectMetadata = amazonS3.getObjectMetadata(getObjectMetadataRequest);
        return objectMetadata.getContentRange()[1];
    }

    public static interface RetryableS3DownloadTask {
        public S3Object getS3ObjectStream();

        public boolean needIntegrityCheck();
    }
}

