/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.Immutable;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.internal.SdkPredicate;
import com.amazonaws.regions.Regions;
import com.amazonaws.retry.internal.AuthErrorRetryStrategy;
import com.amazonaws.retry.internal.AuthRetryParameters;
import com.amazonaws.services.s3.internal.AWSS3V4Signer;
import com.amazonaws.services.s3.internal.BucketNameUtils;
import com.amazonaws.services.s3.internal.IsSigV4RetryablePredicate;
import com.amazonaws.services.s3.internal.S3RequestEndpointResolver;
import com.amazonaws.util.StringUtils;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Immutable
public class S3V4AuthErrorRetryStrategy
implements AuthErrorRetryStrategy {
    private static Log log = LogFactory.getLog(S3V4AuthErrorRetryStrategy.class);
    private static final String V4_REGION_WARNING = "please use region-specific endpoint to access buckets located in regions that require V4 signing.";
    private final S3RequestEndpointResolver endpointResolver;
    private final SdkPredicate<AmazonServiceException> sigV4RetryPredicate;

    public S3V4AuthErrorRetryStrategy(S3RequestEndpointResolver s3RequestEndpointResolver) {
        this(s3RequestEndpointResolver, new IsSigV4RetryablePredicate());
    }

    S3V4AuthErrorRetryStrategy(S3RequestEndpointResolver s3RequestEndpointResolver, SdkPredicate<AmazonServiceException> sdkPredicate) {
        this.endpointResolver = s3RequestEndpointResolver;
        this.sigV4RetryPredicate = sdkPredicate;
    }

    @Override
    public AuthRetryParameters shouldRetryWithAuthParam(Request<?> request, HttpResponse httpResponse, AmazonServiceException amazonServiceException) {
        if (!this.sigV4RetryPredicate.test(amazonServiceException)) {
            return null;
        }
        if (S3V4AuthErrorRetryStrategy.hasServingRegionHeader(httpResponse)) {
            return this.redirectToRegionInHeader(request, httpResponse);
        }
        if (this.canUseVirtualAddressing()) {
            return this.redirectToS3External();
        }
        throw new SdkClientException(V4_REGION_WARNING, amazonServiceException);
    }

    private boolean canUseVirtualAddressing() {
        return BucketNameUtils.isDNSBucketName(this.endpointResolver.getBucketName());
    }

    private AuthRetryParameters redirectToRegionInHeader(Request<?> request, HttpResponse httpResponse) {
        String string = S3V4AuthErrorRetryStrategy.getServingRegionHeader(httpResponse);
        AWSS3V4Signer aWSS3V4Signer = this.buildSigV4Signer(string);
        this.endpointResolver.resolveRequestEndpoint(request, string);
        return this.buildRetryParams(aWSS3V4Signer, request.getEndpoint());
    }

    private AuthRetryParameters redirectToS3External() {
        AWSS3V4Signer aWSS3V4Signer = this.buildSigV4Signer(Regions.US_EAST_1.getName());
        try {
            URI uRI = new URI(String.format("https://%s.s3-external-1.amazonaws.com", this.endpointResolver.getBucketName()));
            return this.buildRetryParams(aWSS3V4Signer, uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SdkClientException("Failed to re-send the request to \"s3-external-1.amazonaws.com\". please use region-specific endpoint to access buckets located in regions that require V4 signing.", uRISyntaxException);
        }
    }

    private AWSS3V4Signer buildSigV4Signer(String string) {
        AWSS3V4Signer aWSS3V4Signer = new AWSS3V4Signer();
        aWSS3V4Signer.setRegionName(string);
        aWSS3V4Signer.setServiceName("s3");
        return aWSS3V4Signer;
    }

    private AuthRetryParameters buildRetryParams(AWSS3V4Signer aWSS3V4Signer, URI uRI) {
        log.warn("Attempting to re-send the request to " + uRI.getHost() + " with AWS V4 authentication. To avoid this warning in the future, " + V4_REGION_WARNING);
        return new AuthRetryParameters(aWSS3V4Signer, uRI);
    }

    private static boolean hasServingRegionHeader(HttpResponse httpResponse) {
        return !StringUtils.isNullOrEmpty(S3V4AuthErrorRetryStrategy.getServingRegionHeader(httpResponse));
    }

    private static String getServingRegionHeader(HttpResponse httpResponse) {
        return httpResponse.getHeaders().get("x-amz-region");
    }
}

