/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.util.HostnameValidator;
import java.net.URI;

@SdkInternalApi
public final class S3OutpostAccessPointBuilder {
    private URI endpointOverride;
    private String accessPointName;
    private String outpostId;
    private String region;
    private String accountId;
    private String protocol;
    private String domain;

    private S3OutpostAccessPointBuilder() {
    }

    public static S3OutpostAccessPointBuilder create() {
        return new S3OutpostAccessPointBuilder();
    }

    public S3OutpostAccessPointBuilder withEndpointOverride(URI uRI) {
        this.endpointOverride = uRI;
        return this;
    }

    public S3OutpostAccessPointBuilder withAccessPointName(String string) {
        this.accessPointName = string;
        return this;
    }

    public S3OutpostAccessPointBuilder withRegion(String string) {
        this.region = string;
        return this;
    }

    public S3OutpostAccessPointBuilder withAccountId(String string) {
        this.accountId = string;
        return this;
    }

    public S3OutpostAccessPointBuilder withOutpostId(String string) {
        this.outpostId = string;
        return this;
    }

    public S3OutpostAccessPointBuilder withProtocol(String string) {
        this.protocol = string;
        return this;
    }

    public S3OutpostAccessPointBuilder withDomain(String string) {
        this.domain = string;
        return this;
    }

    public URI toURI() {
        String string;
        HostnameValidator.validateHostnameCompliant(this.outpostId, "outpostId", "outpost ARN");
        HostnameValidator.validateHostnameCompliant(this.accountId, "accountId", "outpost ARN");
        HostnameValidator.validateHostnameCompliant(this.accessPointName, "accessPointName", "outpost ARN");
        if (this.endpointOverride == null) {
            string = String.format("%s://%s-%s.%s.s3-outposts.%s.%s", this.protocol, this.accessPointName, this.accountId, this.outpostId, this.region, this.domain);
        } else {
            StringBuilder stringBuilder = new StringBuilder(this.endpointOverride.getHost());
            if (this.endpointOverride.getPort() > 0) {
                stringBuilder.append(":").append(this.endpointOverride.getPort());
            }
            if (this.endpointOverride.getPath() != null) {
                stringBuilder.append(this.endpointOverride.getPath());
            }
            string = String.format("%s://%s-%s.%s.%s", this.protocol, this.accessPointName, this.accountId, this.outpostId, stringBuilder);
        }
        return URI.create(string);
    }
}

