/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.services.s3.internal.AbstractS3ResponseHandler;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;

public class S3ObjectResponseHandler
extends AbstractS3ResponseHandler<S3Object> {
    @Override
    public AmazonWebServiceResponse<S3Object> handle(HttpResponse httpResponse) throws Exception {
        S3Object s3Object = new S3Object();
        AmazonWebServiceResponse<S3Object> amazonWebServiceResponse = this.parseResponseMetadata(httpResponse);
        if (httpResponse.getHeaders().get("x-amz-website-redirect-location") != null) {
            s3Object.setRedirectLocation(httpResponse.getHeaders().get("x-amz-website-redirect-location"));
        }
        if (httpResponse.getHeaders().get("x-amz-request-charged") != null) {
            s3Object.setRequesterCharged(true);
        }
        if (httpResponse.getHeaders().get("x-amz-tagging-count") != null) {
            s3Object.setTaggingCount(Integer.parseInt(httpResponse.getHeaders().get("x-amz-tagging-count")));
        }
        ObjectMetadata objectMetadata = s3Object.getObjectMetadata();
        this.populateObjectMetadata(httpResponse, objectMetadata);
        s3Object.setObjectContent(new S3ObjectInputStream(httpResponse.getContent(), httpResponse.getHttpRequest()));
        amazonWebServiceResponse.setResult(s3Object);
        return amazonWebServiceResponse;
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return true;
    }

    private long getContentLength(HttpResponse httpResponse) {
        String string = httpResponse.getHeader("Content-Length");
        if (string == null) {
            return -1L;
        }
        return Long.parseLong(httpResponse.getHeader("Content-Length"));
    }
}

