/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.s3.S3Resource;
import com.amazonaws.services.s3.S3ResourceType;
import com.amazonaws.util.ValidationUtils;

@SdkInternalApi
public final class S3ObjectLambdasResource
implements S3Resource {
    private final String partition;
    private final String region;
    private final String accountId;
    private final String accessPointName;

    private S3ObjectLambdasResource(Builder builder) {
        this.partition = ValidationUtils.assertStringNotEmpty(builder.partition, "partition");
        this.region = ValidationUtils.assertStringNotEmpty(builder.region, "region");
        this.accountId = ValidationUtils.assertStringNotEmpty(builder.accountId, "accountId");
        this.accessPointName = ValidationUtils.assertStringNotEmpty(builder.accessPointName, "accessPointName");
    }

    @Override
    public String getType() {
        return S3ResourceType.OBJECT_LAMBDAS.toString();
    }

    @Override
    public S3Resource getParentS3Resource() {
        return null;
    }

    @Override
    public String getPartition() {
        return this.partition;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public String getAccountId() {
        return this.accountId;
    }

    public String getAccessPointName() {
        return this.accessPointName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        S3ObjectLambdasResource s3ObjectLambdasResource = (S3ObjectLambdasResource)object;
        if (this.partition != null ? !this.partition.equals(s3ObjectLambdasResource.partition) : s3ObjectLambdasResource.partition != null) {
            return false;
        }
        if (this.region != null ? !this.region.equals(s3ObjectLambdasResource.region) : s3ObjectLambdasResource.region != null) {
            return false;
        }
        if (this.accountId != null ? !this.accountId.equals(s3ObjectLambdasResource.accountId) : s3ObjectLambdasResource.accountId != null) {
            return false;
        }
        return this.accessPointName != null ? this.accessPointName.equals(s3ObjectLambdasResource.accessPointName) : s3ObjectLambdasResource.accessPointName == null;
    }

    public int hashCode() {
        int n = this.partition != null ? this.partition.hashCode() : 0;
        n = 31 * n + (this.region != null ? this.region.hashCode() : 0);
        n = 31 * n + (this.accountId != null ? this.accountId.hashCode() : 0);
        n = 31 * n + (this.accessPointName != null ? this.accessPointName.hashCode() : 0);
        return n;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String partition;
        private String region;
        private String accountId;
        private String accessPointName;

        private Builder() {
        }

        public Builder withPartition(String string) {
            this.partition = string;
            return this;
        }

        public Builder withRegion(String string) {
            this.region = string;
            return this;
        }

        public Builder withAccountId(String string) {
            this.accountId = string;
            return this;
        }

        public Builder withAccessPointName(String string) {
            this.accessPointName = string;
            return this;
        }

        public S3ObjectLambdasResource build() {
            return new S3ObjectLambdasResource(this);
        }
    }
}

