/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.services.s3.internal.AmazonS3ExceptionBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XmlUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class S3ErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    private static final Log log = LogFactory.getLog(S3ErrorResponseHandler.class);
    private final ClientConfiguration clientConfiguration;

    public S3ErrorResponseHandler(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
    }

    @Override
    public AmazonServiceException handle(HttpResponse httpResponse) throws XMLStreamException {
        AmazonServiceException amazonServiceException = this.createException(httpResponse);
        amazonServiceException.setHttpHeaders(httpResponse.getHeaders());
        return amazonServiceException;
    }

    private AmazonServiceException createException(HttpResponse httpResponse) throws XMLStreamException {
        String string;
        block20: {
            InputStream inputStream2 = httpResponse.getContent();
            String string2 = null;
            if (inputStream2 == null || httpResponse.getRequest().getHttpMethod() == HttpMethodName.HEAD) {
                return this.createExceptionFromHeaders(httpResponse, null);
            }
            string = null;
            try {
                string = IOUtils.toString(inputStream2);
            }
            catch (IOException iOException) {
                if (log.isDebugEnabled()) {
                    log.debug("Failed in parsing the error response : ", iOException);
                }
                return this.createExceptionFromHeaders(httpResponse, null);
            }
            XMLStreamReader xMLStreamReader = XmlUtils.getXmlInputFactory().createXMLStreamReader(new ByteArrayInputStream(string.getBytes(StringUtils.UTF8)));
            try {
                int n = 0;
                AmazonS3ExceptionBuilder amazonS3ExceptionBuilder = new AmazonS3ExceptionBuilder();
                amazonS3ExceptionBuilder.setErrorResponseXml(string);
                amazonS3ExceptionBuilder.setStatusCode(httpResponse.getStatusCode());
                amazonS3ExceptionBuilder.setCloudFrontId(httpResponse.getHeaders().get("X-Amz-Cf-Id"));
                String string3 = httpResponse.getHeader("x-amz-bucket-region");
                if (string3 != null) {
                    amazonS3ExceptionBuilder.addAdditionalDetail("x-amz-bucket-region", string3);
                }
                boolean bl = false;
                block10: while (xMLStreamReader.hasNext()) {
                    int n2 = xMLStreamReader.next();
                    switch (n2) {
                        case 1: {
                            String string4 = xMLStreamReader.getLocalName();
                            if (++n == 1 && !S3ErrorTags.Error.toString().equals(string4)) {
                                return this.createExceptionFromHeaders(httpResponse, "Unable to parse error response. Error XML Not in proper format." + string);
                            }
                            if (!S3ErrorTags.Error.toString().equals(string4)) continue block10;
                            bl = true;
                            continue block10;
                        }
                        case 4: {
                            string2 = xMLStreamReader.getText();
                            if (string2 == null) continue block10;
                            string2 = string2.trim();
                            continue block10;
                        }
                        case 2: {
                            String string4 = xMLStreamReader.getLocalName();
                            if (!bl || --n > 1) {
                                return this.createExceptionFromHeaders(httpResponse, "Unable to parse error response. Error XML Not in proper format." + string);
                            }
                            if (S3ErrorTags.Message.toString().equals(string4)) {
                                amazonS3ExceptionBuilder.setErrorMessage(string2);
                                continue block10;
                            }
                            if (S3ErrorTags.Code.toString().equals(string4)) {
                                amazonS3ExceptionBuilder.setErrorCode(string2);
                                continue block10;
                            }
                            if (S3ErrorTags.RequestId.toString().equals(string4)) {
                                amazonS3ExceptionBuilder.setRequestId(string2);
                                continue block10;
                            }
                            if (S3ErrorTags.HostId.toString().equals(string4)) {
                                amazonS3ExceptionBuilder.setExtendedRequestId(string2);
                                continue block10;
                            }
                            amazonS3ExceptionBuilder.addAdditionalDetail(string4, string2);
                            continue block10;
                        }
                        case 8: {
                            amazonS3ExceptionBuilder.setProxyHost(this.clientConfiguration.getProxyHost());
                            return amazonS3ExceptionBuilder.build();
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (!log.isDebugEnabled()) break block20;
                log.debug("Failed in parsing the error response : " + string, exception);
            }
        }
        return this.createExceptionFromHeaders(httpResponse, string);
    }

    private AmazonS3Exception createExceptionFromHeaders(HttpResponse httpResponse, String string) {
        Map<String, String> map = httpResponse.getHeaders();
        int n = httpResponse.getStatusCode();
        AmazonS3ExceptionBuilder amazonS3ExceptionBuilder = new AmazonS3ExceptionBuilder();
        amazonS3ExceptionBuilder.setErrorMessage(httpResponse.getStatusText());
        amazonS3ExceptionBuilder.setErrorResponseXml(string);
        amazonS3ExceptionBuilder.setStatusCode(n);
        amazonS3ExceptionBuilder.setExtendedRequestId(map.get("x-amz-id-2"));
        amazonS3ExceptionBuilder.setRequestId(map.get("x-amz-request-id"));
        amazonS3ExceptionBuilder.setCloudFrontId(map.get("X-Amz-Cf-Id"));
        amazonS3ExceptionBuilder.setErrorCode(n + " " + httpResponse.getStatusText());
        amazonS3ExceptionBuilder.addAdditionalDetail("x-amz-bucket-region", httpResponse.getHeaders().get("x-amz-bucket-region"));
        amazonS3ExceptionBuilder.setProxyHost(this.clientConfiguration.getProxyHost());
        return amazonS3ExceptionBuilder.build();
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }

    private static enum S3ErrorTags {
        Error,
        Message,
        Code,
        RequestId,
        HostId;

    }
}

