/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.util.HostnameValidator;
import java.net.URI;

@SdkInternalApi
public class S3AccessPointBuilder {
    private URI endpointOverride;
    private Boolean dualstackEnabled;
    private Boolean fipsEnabled;
    private String accessPointName;
    private String region;
    private String accountId;
    private String protocol;
    private String domain;

    private S3AccessPointBuilder() {
    }

    public static S3AccessPointBuilder create() {
        return new S3AccessPointBuilder();
    }

    public void setEndpointOverride(URI uRI) {
        this.endpointOverride = uRI;
    }

    public S3AccessPointBuilder withEndpointOverride(URI uRI) {
        this.setEndpointOverride(uRI);
        return this;
    }

    public void setDualstackEnabled(Boolean bl) {
        this.dualstackEnabled = bl;
    }

    public S3AccessPointBuilder withDualstackEnabled(Boolean bl) {
        this.setDualstackEnabled(bl);
        return this;
    }

    public void setFipsEnabled(Boolean bl) {
        this.fipsEnabled = bl;
    }

    public S3AccessPointBuilder withFipsEnabled(Boolean bl) {
        this.fipsEnabled = bl;
        return this;
    }

    public void setAccessPointName(String string) {
        this.accessPointName = string;
    }

    public S3AccessPointBuilder withAccessPointName(String string) {
        this.setAccessPointName(string);
        return this;
    }

    public void setRegion(String string) {
        this.region = string;
    }

    public S3AccessPointBuilder withRegion(String string) {
        this.setRegion(string);
        return this;
    }

    public void setAccountId(String string) {
        this.accountId = string;
    }

    public S3AccessPointBuilder withAccountId(String string) {
        this.setAccountId(string);
        return this;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public S3AccessPointBuilder withProtocol(String string) {
        this.setProtocol(string);
        return this;
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    public S3AccessPointBuilder withDomain(String string) {
        this.setDomain(string);
        return this;
    }

    public URI toURI() {
        String string;
        HostnameValidator.validateHostnameCompliant(this.accountId, "accountId", "access point ARN");
        HostnameValidator.validateHostnameCompliant(this.accessPointName, "accessPointName", "access point ARN");
        if (this.endpointOverride == null) {
            String string2 = Boolean.TRUE.equals(this.fipsEnabled) ? "-fips" : "";
            String string3 = Boolean.TRUE.equals(this.dualstackEnabled) ? "dualstack." : "";
            string = String.format("%s://%s-%s.s3-accesspoint%s.%s%s.%s", this.protocol, this.accessPointName, this.accountId, string2, string3, this.region, this.domain);
        } else {
            if (Boolean.TRUE.equals(this.fipsEnabled)) {
                throw new IllegalArgumentException("FIPS regions are not supported with an endpoint override specified");
            }
            if (Boolean.TRUE.equals(this.dualstackEnabled)) {
                throw new IllegalArgumentException("Dual stack is not supported with an endpoint override specified");
            }
            StringBuilder stringBuilder = new StringBuilder(this.endpointOverride.getHost());
            if (this.endpointOverride.getPort() > 0) {
                stringBuilder.append(":").append(this.endpointOverride.getPort());
            }
            if (this.endpointOverride.getPath() != null) {
                stringBuilder.append(this.endpointOverride.getPath());
            }
            string = String.format("%s://%s-%s.%s", this.protocol, this.accessPointName, this.accountId, stringBuilder);
        }
        return URI.create(string);
    }
}

