/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import java.util.HashMap;
import java.util.Map;

public class AmazonS3ExceptionBuilder {
    private String requestId;
    private String errorCode;
    private String errorMessage;
    private int statusCode;
    private String extendedRequestId;
    private String cloudFrontId;
    private Map<String, String> additionalDetails;
    private String errorResponseXml;
    private String proxyHost;

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String string) {
        this.requestId = string;
    }

    public void setErrorCode(String string) {
        this.errorCode = string;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public void setStatusCode(int n) {
        this.statusCode = n;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getExtendedRequestId() {
        return this.extendedRequestId;
    }

    public void setExtendedRequestId(String string) {
        this.extendedRequestId = string;
    }

    public String getCloudFrontId() {
        return this.cloudFrontId;
    }

    public void setCloudFrontId(String string) {
        this.cloudFrontId = string;
    }

    public Map<String, String> getAdditionalDetails() {
        return this.additionalDetails;
    }

    public void setAdditionalDetails(Map<String, String> map) {
        this.additionalDetails = map;
    }

    public void addAdditionalDetail(String string, String string2) {
        String string3;
        if (string2 == null || string2.trim().isEmpty()) {
            return;
        }
        if (this.additionalDetails == null) {
            this.additionalDetails = new HashMap<String, String>();
        }
        if ((string3 = this.additionalDetails.get(string)) != null && !string3.trim().isEmpty()) {
            string2 = string3 + "-" + string2;
        }
        if (!string2.isEmpty()) {
            this.additionalDetails.put(string, string2);
        }
    }

    public String getErrorResponseXml() {
        return this.errorResponseXml;
    }

    public void setErrorResponseXml(String string) {
        this.errorResponseXml = string;
    }

    public void setProxyHost(String string) {
        this.proxyHost = string;
    }

    public AmazonS3Exception build() {
        AmazonS3Exception amazonS3Exception = this.errorResponseXml == null ? new AmazonS3Exception(this.errorMessage) : new AmazonS3Exception(this.errorMessage, this.errorResponseXml);
        amazonS3Exception.setErrorCode(this.errorCode);
        amazonS3Exception.setExtendedRequestId(this.extendedRequestId);
        amazonS3Exception.setStatusCode(this.statusCode);
        amazonS3Exception.setRequestId(this.requestId);
        amazonS3Exception.setCloudFrontId(this.cloudFrontId);
        amazonS3Exception.setAdditionalDetails(this.additionalDetails);
        amazonS3Exception.setErrorType(this.errorTypeOf(this.statusCode));
        amazonS3Exception.setProxyHost(this.proxyHost);
        return amazonS3Exception;
    }

    private AmazonServiceException.ErrorType errorTypeOf(int n) {
        return n >= 500 ? AmazonServiceException.ErrorType.Service : AmazonServiceException.ErrorType.Client;
    }
}

