/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.arn.Arn;
import com.amazonaws.arn.ArnResource;
import com.amazonaws.services.s3.S3AccessPointResource;
import com.amazonaws.services.s3.internal.IntermediateOutpostResource;
import com.amazonaws.util.StringUtils;

@SdkInternalApi
public class S3ArnUtils {
    private static final int OUTPOST_ID_START_INDEX = "outpost".length() + 1;

    private S3ArnUtils() {
    }

    public static S3AccessPointResource parseS3AccessPointArn(Arn arn) {
        return S3AccessPointResource.builder().withPartition(arn.getPartition()).withRegion(arn.getRegion()).withAccountId(arn.getAccountId()).withAccessPointName(arn.getResource().getResource()).build();
    }

    public static IntermediateOutpostResource parseOutpostArn(Arn arn) {
        String string = arn.getResourceAsString();
        Integer n = null;
        for (int i = OUTPOST_ID_START_INDEX; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != ':' && c != '/') continue;
            n = i;
            break;
        }
        if (n == null) {
            throw new IllegalArgumentException("Invalid format for S3 outpost ARN, missing outpostId");
        }
        String string2 = string.substring(OUTPOST_ID_START_INDEX, n);
        if (StringUtils.isNullOrEmpty(string2)) {
            throw new IllegalArgumentException("Invalid format for S3 outpost ARN, missing outpostId");
        }
        String string3 = string.substring(n + 1);
        if (StringUtils.isNullOrEmpty(string3)) {
            throw new IllegalArgumentException("Invalid format for S3 outpost ARN");
        }
        return IntermediateOutpostResource.builder().withOutpostId(string2).withOutpostSubresource(ArnResource.fromString(string3)).build();
    }
}

