/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.kms.model.MessageType;
import com.amazonaws.services.kms.model.SigningAlgorithmSpec;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;

public class VerifyRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String keyId;
    private ByteBuffer message;
    private String messageType;
    private ByteBuffer signature;
    private String signingAlgorithm;
    private SdkInternalList<String> grantTokens;

    public void setKeyId(String string) {
        this.keyId = string;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public VerifyRequest withKeyId(String string) {
        this.setKeyId(string);
        return this;
    }

    public void setMessage(ByteBuffer byteBuffer) {
        this.message = byteBuffer;
    }

    public ByteBuffer getMessage() {
        return this.message;
    }

    public VerifyRequest withMessage(ByteBuffer byteBuffer) {
        this.setMessage(byteBuffer);
        return this;
    }

    public void setMessageType(String string) {
        this.messageType = string;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public VerifyRequest withMessageType(String string) {
        this.setMessageType(string);
        return this;
    }

    public VerifyRequest withMessageType(MessageType messageType) {
        this.messageType = messageType.toString();
        return this;
    }

    public void setSignature(ByteBuffer byteBuffer) {
        this.signature = byteBuffer;
    }

    public ByteBuffer getSignature() {
        return this.signature;
    }

    public VerifyRequest withSignature(ByteBuffer byteBuffer) {
        this.setSignature(byteBuffer);
        return this;
    }

    public void setSigningAlgorithm(String string) {
        this.signingAlgorithm = string;
    }

    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public VerifyRequest withSigningAlgorithm(String string) {
        this.setSigningAlgorithm(string);
        return this;
    }

    public VerifyRequest withSigningAlgorithm(SigningAlgorithmSpec signingAlgorithmSpec) {
        this.signingAlgorithm = signingAlgorithmSpec.toString();
        return this;
    }

    public List<String> getGrantTokens() {
        if (this.grantTokens == null) {
            this.grantTokens = new SdkInternalList();
        }
        return this.grantTokens;
    }

    public void setGrantTokens(Collection<String> collection) {
        if (collection == null) {
            this.grantTokens = null;
            return;
        }
        this.grantTokens = new SdkInternalList<String>(collection);
    }

    public VerifyRequest withGrantTokens(String ... stringArray) {
        if (this.grantTokens == null) {
            this.setGrantTokens(new SdkInternalList<String>(stringArray.length));
        }
        for (String string : stringArray) {
            this.grantTokens.add(string);
        }
        return this;
    }

    public VerifyRequest withGrantTokens(Collection<String> collection) {
        this.setGrantTokens(collection);
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getKeyId() != null) {
            stringBuilder.append("KeyId: ").append(this.getKeyId()).append(",");
        }
        if (this.getMessage() != null) {
            stringBuilder.append("Message: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getMessageType() != null) {
            stringBuilder.append("MessageType: ").append(this.getMessageType()).append(",");
        }
        if (this.getSignature() != null) {
            stringBuilder.append("Signature: ").append(this.getSignature()).append(",");
        }
        if (this.getSigningAlgorithm() != null) {
            stringBuilder.append("SigningAlgorithm: ").append(this.getSigningAlgorithm()).append(",");
        }
        if (this.getGrantTokens() != null) {
            stringBuilder.append("GrantTokens: ").append(this.getGrantTokens());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof VerifyRequest)) {
            return false;
        }
        VerifyRequest verifyRequest = (VerifyRequest)object;
        if (verifyRequest.getKeyId() == null ^ this.getKeyId() == null) {
            return false;
        }
        if (verifyRequest.getKeyId() != null && !verifyRequest.getKeyId().equals(this.getKeyId())) {
            return false;
        }
        if (verifyRequest.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        if (verifyRequest.getMessage() != null && !verifyRequest.getMessage().equals(this.getMessage())) {
            return false;
        }
        if (verifyRequest.getMessageType() == null ^ this.getMessageType() == null) {
            return false;
        }
        if (verifyRequest.getMessageType() != null && !verifyRequest.getMessageType().equals(this.getMessageType())) {
            return false;
        }
        if (verifyRequest.getSignature() == null ^ this.getSignature() == null) {
            return false;
        }
        if (verifyRequest.getSignature() != null && !verifyRequest.getSignature().equals(this.getSignature())) {
            return false;
        }
        if (verifyRequest.getSigningAlgorithm() == null ^ this.getSigningAlgorithm() == null) {
            return false;
        }
        if (verifyRequest.getSigningAlgorithm() != null && !verifyRequest.getSigningAlgorithm().equals(this.getSigningAlgorithm())) {
            return false;
        }
        if (verifyRequest.getGrantTokens() == null ^ this.getGrantTokens() == null) {
            return false;
        }
        return verifyRequest.getGrantTokens() == null || verifyRequest.getGrantTokens().equals(this.getGrantTokens());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getKeyId() == null ? 0 : this.getKeyId().hashCode());
        n2 = 31 * n2 + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        n2 = 31 * n2 + (this.getMessageType() == null ? 0 : this.getMessageType().hashCode());
        n2 = 31 * n2 + (this.getSignature() == null ? 0 : this.getSignature().hashCode());
        n2 = 31 * n2 + (this.getSigningAlgorithm() == null ? 0 : this.getSigningAlgorithm().hashCode());
        n2 = 31 * n2 + (this.getGrantTokens() == null ? 0 : this.getGrantTokens().hashCode());
        return n2;
    }

    @Override
    public VerifyRequest clone() {
        return (VerifyRequest)super.clone();
    }
}

