/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.kms.model.GrantListEntry;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListGrantsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<GrantListEntry> grants;
    private String nextMarker;
    private Boolean truncated;

    public List<GrantListEntry> getGrants() {
        if (this.grants == null) {
            this.grants = new SdkInternalList();
        }
        return this.grants;
    }

    public void setGrants(Collection<GrantListEntry> collection) {
        if (collection == null) {
            this.grants = null;
            return;
        }
        this.grants = new SdkInternalList<GrantListEntry>(collection);
    }

    public ListGrantsResult withGrants(GrantListEntry ... grantListEntryArray) {
        if (this.grants == null) {
            this.setGrants(new SdkInternalList<GrantListEntry>(grantListEntryArray.length));
        }
        for (GrantListEntry grantListEntry : grantListEntryArray) {
            this.grants.add(grantListEntry);
        }
        return this;
    }

    public ListGrantsResult withGrants(Collection<GrantListEntry> collection) {
        this.setGrants(collection);
        return this;
    }

    public void setNextMarker(String string) {
        this.nextMarker = string;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public ListGrantsResult withNextMarker(String string) {
        this.setNextMarker(string);
        return this;
    }

    public void setTruncated(Boolean bl) {
        this.truncated = bl;
    }

    public Boolean getTruncated() {
        return this.truncated;
    }

    public ListGrantsResult withTruncated(Boolean bl) {
        this.setTruncated(bl);
        return this;
    }

    public Boolean isTruncated() {
        return this.truncated;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getGrants() != null) {
            stringBuilder.append("Grants: ").append(this.getGrants()).append(",");
        }
        if (this.getNextMarker() != null) {
            stringBuilder.append("NextMarker: ").append(this.getNextMarker()).append(",");
        }
        if (this.getTruncated() != null) {
            stringBuilder.append("Truncated: ").append(this.getTruncated());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ListGrantsResult)) {
            return false;
        }
        ListGrantsResult listGrantsResult = (ListGrantsResult)object;
        if (listGrantsResult.getGrants() == null ^ this.getGrants() == null) {
            return false;
        }
        if (listGrantsResult.getGrants() != null && !listGrantsResult.getGrants().equals(this.getGrants())) {
            return false;
        }
        if (listGrantsResult.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        if (listGrantsResult.getNextMarker() != null && !listGrantsResult.getNextMarker().equals(this.getNextMarker())) {
            return false;
        }
        if (listGrantsResult.getTruncated() == null ^ this.getTruncated() == null) {
            return false;
        }
        return listGrantsResult.getTruncated() == null || listGrantsResult.getTruncated().equals(this.getTruncated());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getGrants() == null ? 0 : this.getGrants().hashCode());
        n2 = 31 * n2 + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        n2 = 31 * n2 + (this.getTruncated() == null ? 0 : this.getTruncated().hashCode());
        return n2;
    }

    public ListGrantsResult clone() {
        try {
            return (ListGrantsResult)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", cloneNotSupportedException);
        }
    }
}

