/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kms.model.CustomerMasterKeySpec;
import com.amazonaws.services.kms.model.EncryptionAlgorithmSpec;
import com.amazonaws.services.kms.model.ExpirationModelType;
import com.amazonaws.services.kms.model.KeyManagerType;
import com.amazonaws.services.kms.model.KeySpec;
import com.amazonaws.services.kms.model.KeyState;
import com.amazonaws.services.kms.model.KeyUsageType;
import com.amazonaws.services.kms.model.MacAlgorithmSpec;
import com.amazonaws.services.kms.model.MultiRegionConfiguration;
import com.amazonaws.services.kms.model.OriginType;
import com.amazonaws.services.kms.model.SigningAlgorithmSpec;
import com.amazonaws.services.kms.model.transform.KeyMetadataMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class KeyMetadata
implements StructuredPojo,
Serializable,
Cloneable {
    private String aWSAccountId;
    private String keyId;
    private String arn;
    private Date creationDate;
    private Boolean enabled;
    private String description;
    private String keyUsage;
    private String keyState;
    private Date deletionDate;
    private Date validTo;
    private String origin;
    private String customKeyStoreId;
    private String cloudHsmClusterId;
    private String expirationModel;
    private String keyManager;
    @Deprecated
    private String customerMasterKeySpec;
    private String keySpec;
    private SdkInternalList<String> encryptionAlgorithms;
    private SdkInternalList<String> signingAlgorithms;
    private Boolean multiRegion;
    private MultiRegionConfiguration multiRegionConfiguration;
    private Integer pendingDeletionWindowInDays;
    private SdkInternalList<String> macAlgorithms;

    public void setAWSAccountId(String string) {
        this.aWSAccountId = string;
    }

    public String getAWSAccountId() {
        return this.aWSAccountId;
    }

    public KeyMetadata withAWSAccountId(String string) {
        this.setAWSAccountId(string);
        return this;
    }

    public void setKeyId(String string) {
        this.keyId = string;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public KeyMetadata withKeyId(String string) {
        this.setKeyId(string);
        return this;
    }

    public void setArn(String string) {
        this.arn = string;
    }

    public String getArn() {
        return this.arn;
    }

    public KeyMetadata withArn(String string) {
        this.setArn(string);
        return this;
    }

    public void setCreationDate(Date date) {
        this.creationDate = date;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public KeyMetadata withCreationDate(Date date) {
        this.setCreationDate(date);
        return this;
    }

    public void setEnabled(Boolean bl) {
        this.enabled = bl;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public KeyMetadata withEnabled(Boolean bl) {
        this.setEnabled(bl);
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public KeyMetadata withDescription(String string) {
        this.setDescription(string);
        return this;
    }

    public void setKeyUsage(String string) {
        this.keyUsage = string;
    }

    public String getKeyUsage() {
        return this.keyUsage;
    }

    public KeyMetadata withKeyUsage(String string) {
        this.setKeyUsage(string);
        return this;
    }

    public void setKeyUsage(KeyUsageType keyUsageType) {
        this.withKeyUsage(keyUsageType);
    }

    public KeyMetadata withKeyUsage(KeyUsageType keyUsageType) {
        this.keyUsage = keyUsageType.toString();
        return this;
    }

    public void setKeyState(String string) {
        this.keyState = string;
    }

    public String getKeyState() {
        return this.keyState;
    }

    public KeyMetadata withKeyState(String string) {
        this.setKeyState(string);
        return this;
    }

    public void setKeyState(KeyState keyState) {
        this.withKeyState(keyState);
    }

    public KeyMetadata withKeyState(KeyState keyState) {
        this.keyState = keyState.toString();
        return this;
    }

    public void setDeletionDate(Date date) {
        this.deletionDate = date;
    }

    public Date getDeletionDate() {
        return this.deletionDate;
    }

    public KeyMetadata withDeletionDate(Date date) {
        this.setDeletionDate(date);
        return this;
    }

    public void setValidTo(Date date) {
        this.validTo = date;
    }

    public Date getValidTo() {
        return this.validTo;
    }

    public KeyMetadata withValidTo(Date date) {
        this.setValidTo(date);
        return this;
    }

    public void setOrigin(String string) {
        this.origin = string;
    }

    public String getOrigin() {
        return this.origin;
    }

    public KeyMetadata withOrigin(String string) {
        this.setOrigin(string);
        return this;
    }

    public void setOrigin(OriginType originType) {
        this.withOrigin(originType);
    }

    public KeyMetadata withOrigin(OriginType originType) {
        this.origin = originType.toString();
        return this;
    }

    public void setCustomKeyStoreId(String string) {
        this.customKeyStoreId = string;
    }

    public String getCustomKeyStoreId() {
        return this.customKeyStoreId;
    }

    public KeyMetadata withCustomKeyStoreId(String string) {
        this.setCustomKeyStoreId(string);
        return this;
    }

    public void setCloudHsmClusterId(String string) {
        this.cloudHsmClusterId = string;
    }

    public String getCloudHsmClusterId() {
        return this.cloudHsmClusterId;
    }

    public KeyMetadata withCloudHsmClusterId(String string) {
        this.setCloudHsmClusterId(string);
        return this;
    }

    public void setExpirationModel(String string) {
        this.expirationModel = string;
    }

    public String getExpirationModel() {
        return this.expirationModel;
    }

    public KeyMetadata withExpirationModel(String string) {
        this.setExpirationModel(string);
        return this;
    }

    public void setExpirationModel(ExpirationModelType expirationModelType) {
        this.withExpirationModel(expirationModelType);
    }

    public KeyMetadata withExpirationModel(ExpirationModelType expirationModelType) {
        this.expirationModel = expirationModelType.toString();
        return this;
    }

    public void setKeyManager(String string) {
        this.keyManager = string;
    }

    public String getKeyManager() {
        return this.keyManager;
    }

    public KeyMetadata withKeyManager(String string) {
        this.setKeyManager(string);
        return this;
    }

    public void setKeyManager(KeyManagerType keyManagerType) {
        this.withKeyManager(keyManagerType);
    }

    public KeyMetadata withKeyManager(KeyManagerType keyManagerType) {
        this.keyManager = keyManagerType.toString();
        return this;
    }

    @Deprecated
    public void setCustomerMasterKeySpec(String string) {
        this.customerMasterKeySpec = string;
    }

    @Deprecated
    public String getCustomerMasterKeySpec() {
        return this.customerMasterKeySpec;
    }

    @Deprecated
    public KeyMetadata withCustomerMasterKeySpec(String string) {
        this.setCustomerMasterKeySpec(string);
        return this;
    }

    @Deprecated
    public void setCustomerMasterKeySpec(CustomerMasterKeySpec customerMasterKeySpec) {
        this.withCustomerMasterKeySpec(customerMasterKeySpec);
    }

    @Deprecated
    public KeyMetadata withCustomerMasterKeySpec(CustomerMasterKeySpec customerMasterKeySpec) {
        this.customerMasterKeySpec = customerMasterKeySpec.toString();
        return this;
    }

    public void setKeySpec(String string) {
        this.keySpec = string;
    }

    public String getKeySpec() {
        return this.keySpec;
    }

    public KeyMetadata withKeySpec(String string) {
        this.setKeySpec(string);
        return this;
    }

    public void setKeySpec(KeySpec keySpec) {
        this.withKeySpec(keySpec);
    }

    public KeyMetadata withKeySpec(KeySpec keySpec) {
        this.keySpec = keySpec.toString();
        return this;
    }

    public List<String> getEncryptionAlgorithms() {
        if (this.encryptionAlgorithms == null) {
            this.encryptionAlgorithms = new SdkInternalList();
        }
        return this.encryptionAlgorithms;
    }

    public void setEncryptionAlgorithms(Collection<String> collection) {
        if (collection == null) {
            this.encryptionAlgorithms = null;
            return;
        }
        this.encryptionAlgorithms = new SdkInternalList<String>(collection);
    }

    public KeyMetadata withEncryptionAlgorithms(String ... stringArray) {
        if (this.encryptionAlgorithms == null) {
            this.setEncryptionAlgorithms(new SdkInternalList<String>(stringArray.length));
        }
        for (String string : stringArray) {
            this.encryptionAlgorithms.add(string);
        }
        return this;
    }

    public KeyMetadata withEncryptionAlgorithms(Collection<String> collection) {
        this.setEncryptionAlgorithms(collection);
        return this;
    }

    public KeyMetadata withEncryptionAlgorithms(EncryptionAlgorithmSpec ... encryptionAlgorithmSpecArray) {
        SdkInternalList<String> sdkInternalList = new SdkInternalList<String>(encryptionAlgorithmSpecArray.length);
        for (EncryptionAlgorithmSpec encryptionAlgorithmSpec : encryptionAlgorithmSpecArray) {
            sdkInternalList.add(encryptionAlgorithmSpec.toString());
        }
        if (this.getEncryptionAlgorithms() == null) {
            this.setEncryptionAlgorithms(sdkInternalList);
        } else {
            this.getEncryptionAlgorithms().addAll(sdkInternalList);
        }
        return this;
    }

    public List<String> getSigningAlgorithms() {
        if (this.signingAlgorithms == null) {
            this.signingAlgorithms = new SdkInternalList();
        }
        return this.signingAlgorithms;
    }

    public void setSigningAlgorithms(Collection<String> collection) {
        if (collection == null) {
            this.signingAlgorithms = null;
            return;
        }
        this.signingAlgorithms = new SdkInternalList<String>(collection);
    }

    public KeyMetadata withSigningAlgorithms(String ... stringArray) {
        if (this.signingAlgorithms == null) {
            this.setSigningAlgorithms(new SdkInternalList<String>(stringArray.length));
        }
        for (String string : stringArray) {
            this.signingAlgorithms.add(string);
        }
        return this;
    }

    public KeyMetadata withSigningAlgorithms(Collection<String> collection) {
        this.setSigningAlgorithms(collection);
        return this;
    }

    public KeyMetadata withSigningAlgorithms(SigningAlgorithmSpec ... signingAlgorithmSpecArray) {
        SdkInternalList<String> sdkInternalList = new SdkInternalList<String>(signingAlgorithmSpecArray.length);
        for (SigningAlgorithmSpec signingAlgorithmSpec : signingAlgorithmSpecArray) {
            sdkInternalList.add(signingAlgorithmSpec.toString());
        }
        if (this.getSigningAlgorithms() == null) {
            this.setSigningAlgorithms(sdkInternalList);
        } else {
            this.getSigningAlgorithms().addAll(sdkInternalList);
        }
        return this;
    }

    public void setMultiRegion(Boolean bl) {
        this.multiRegion = bl;
    }

    public Boolean getMultiRegion() {
        return this.multiRegion;
    }

    public KeyMetadata withMultiRegion(Boolean bl) {
        this.setMultiRegion(bl);
        return this;
    }

    public Boolean isMultiRegion() {
        return this.multiRegion;
    }

    public void setMultiRegionConfiguration(MultiRegionConfiguration multiRegionConfiguration) {
        this.multiRegionConfiguration = multiRegionConfiguration;
    }

    public MultiRegionConfiguration getMultiRegionConfiguration() {
        return this.multiRegionConfiguration;
    }

    public KeyMetadata withMultiRegionConfiguration(MultiRegionConfiguration multiRegionConfiguration) {
        this.setMultiRegionConfiguration(multiRegionConfiguration);
        return this;
    }

    public void setPendingDeletionWindowInDays(Integer n) {
        this.pendingDeletionWindowInDays = n;
    }

    public Integer getPendingDeletionWindowInDays() {
        return this.pendingDeletionWindowInDays;
    }

    public KeyMetadata withPendingDeletionWindowInDays(Integer n) {
        this.setPendingDeletionWindowInDays(n);
        return this;
    }

    public List<String> getMacAlgorithms() {
        if (this.macAlgorithms == null) {
            this.macAlgorithms = new SdkInternalList();
        }
        return this.macAlgorithms;
    }

    public void setMacAlgorithms(Collection<String> collection) {
        if (collection == null) {
            this.macAlgorithms = null;
            return;
        }
        this.macAlgorithms = new SdkInternalList<String>(collection);
    }

    public KeyMetadata withMacAlgorithms(String ... stringArray) {
        if (this.macAlgorithms == null) {
            this.setMacAlgorithms(new SdkInternalList<String>(stringArray.length));
        }
        for (String string : stringArray) {
            this.macAlgorithms.add(string);
        }
        return this;
    }

    public KeyMetadata withMacAlgorithms(Collection<String> collection) {
        this.setMacAlgorithms(collection);
        return this;
    }

    public KeyMetadata withMacAlgorithms(MacAlgorithmSpec ... macAlgorithmSpecArray) {
        SdkInternalList<String> sdkInternalList = new SdkInternalList<String>(macAlgorithmSpecArray.length);
        for (MacAlgorithmSpec macAlgorithmSpec : macAlgorithmSpecArray) {
            sdkInternalList.add(macAlgorithmSpec.toString());
        }
        if (this.getMacAlgorithms() == null) {
            this.setMacAlgorithms(sdkInternalList);
        } else {
            this.getMacAlgorithms().addAll(sdkInternalList);
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getAWSAccountId() != null) {
            stringBuilder.append("AWSAccountId: ").append(this.getAWSAccountId()).append(",");
        }
        if (this.getKeyId() != null) {
            stringBuilder.append("KeyId: ").append(this.getKeyId()).append(",");
        }
        if (this.getArn() != null) {
            stringBuilder.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getCreationDate() != null) {
            stringBuilder.append("CreationDate: ").append(this.getCreationDate()).append(",");
        }
        if (this.getEnabled() != null) {
            stringBuilder.append("Enabled: ").append(this.getEnabled()).append(",");
        }
        if (this.getDescription() != null) {
            stringBuilder.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getKeyUsage() != null) {
            stringBuilder.append("KeyUsage: ").append(this.getKeyUsage()).append(",");
        }
        if (this.getKeyState() != null) {
            stringBuilder.append("KeyState: ").append(this.getKeyState()).append(",");
        }
        if (this.getDeletionDate() != null) {
            stringBuilder.append("DeletionDate: ").append(this.getDeletionDate()).append(",");
        }
        if (this.getValidTo() != null) {
            stringBuilder.append("ValidTo: ").append(this.getValidTo()).append(",");
        }
        if (this.getOrigin() != null) {
            stringBuilder.append("Origin: ").append(this.getOrigin()).append(",");
        }
        if (this.getCustomKeyStoreId() != null) {
            stringBuilder.append("CustomKeyStoreId: ").append(this.getCustomKeyStoreId()).append(",");
        }
        if (this.getCloudHsmClusterId() != null) {
            stringBuilder.append("CloudHsmClusterId: ").append(this.getCloudHsmClusterId()).append(",");
        }
        if (this.getExpirationModel() != null) {
            stringBuilder.append("ExpirationModel: ").append(this.getExpirationModel()).append(",");
        }
        if (this.getKeyManager() != null) {
            stringBuilder.append("KeyManager: ").append(this.getKeyManager()).append(",");
        }
        if (this.getCustomerMasterKeySpec() != null) {
            stringBuilder.append("CustomerMasterKeySpec: ").append(this.getCustomerMasterKeySpec()).append(",");
        }
        if (this.getKeySpec() != null) {
            stringBuilder.append("KeySpec: ").append(this.getKeySpec()).append(",");
        }
        if (this.getEncryptionAlgorithms() != null) {
            stringBuilder.append("EncryptionAlgorithms: ").append(this.getEncryptionAlgorithms()).append(",");
        }
        if (this.getSigningAlgorithms() != null) {
            stringBuilder.append("SigningAlgorithms: ").append(this.getSigningAlgorithms()).append(",");
        }
        if (this.getMultiRegion() != null) {
            stringBuilder.append("MultiRegion: ").append(this.getMultiRegion()).append(",");
        }
        if (this.getMultiRegionConfiguration() != null) {
            stringBuilder.append("MultiRegionConfiguration: ").append(this.getMultiRegionConfiguration()).append(",");
        }
        if (this.getPendingDeletionWindowInDays() != null) {
            stringBuilder.append("PendingDeletionWindowInDays: ").append(this.getPendingDeletionWindowInDays()).append(",");
        }
        if (this.getMacAlgorithms() != null) {
            stringBuilder.append("MacAlgorithms: ").append(this.getMacAlgorithms());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof KeyMetadata)) {
            return false;
        }
        KeyMetadata keyMetadata = (KeyMetadata)object;
        if (keyMetadata.getAWSAccountId() == null ^ this.getAWSAccountId() == null) {
            return false;
        }
        if (keyMetadata.getAWSAccountId() != null && !keyMetadata.getAWSAccountId().equals(this.getAWSAccountId())) {
            return false;
        }
        if (keyMetadata.getKeyId() == null ^ this.getKeyId() == null) {
            return false;
        }
        if (keyMetadata.getKeyId() != null && !keyMetadata.getKeyId().equals(this.getKeyId())) {
            return false;
        }
        if (keyMetadata.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (keyMetadata.getArn() != null && !keyMetadata.getArn().equals(this.getArn())) {
            return false;
        }
        if (keyMetadata.getCreationDate() == null ^ this.getCreationDate() == null) {
            return false;
        }
        if (keyMetadata.getCreationDate() != null && !keyMetadata.getCreationDate().equals(this.getCreationDate())) {
            return false;
        }
        if (keyMetadata.getEnabled() == null ^ this.getEnabled() == null) {
            return false;
        }
        if (keyMetadata.getEnabled() != null && !keyMetadata.getEnabled().equals(this.getEnabled())) {
            return false;
        }
        if (keyMetadata.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (keyMetadata.getDescription() != null && !keyMetadata.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (keyMetadata.getKeyUsage() == null ^ this.getKeyUsage() == null) {
            return false;
        }
        if (keyMetadata.getKeyUsage() != null && !keyMetadata.getKeyUsage().equals(this.getKeyUsage())) {
            return false;
        }
        if (keyMetadata.getKeyState() == null ^ this.getKeyState() == null) {
            return false;
        }
        if (keyMetadata.getKeyState() != null && !keyMetadata.getKeyState().equals(this.getKeyState())) {
            return false;
        }
        if (keyMetadata.getDeletionDate() == null ^ this.getDeletionDate() == null) {
            return false;
        }
        if (keyMetadata.getDeletionDate() != null && !keyMetadata.getDeletionDate().equals(this.getDeletionDate())) {
            return false;
        }
        if (keyMetadata.getValidTo() == null ^ this.getValidTo() == null) {
            return false;
        }
        if (keyMetadata.getValidTo() != null && !keyMetadata.getValidTo().equals(this.getValidTo())) {
            return false;
        }
        if (keyMetadata.getOrigin() == null ^ this.getOrigin() == null) {
            return false;
        }
        if (keyMetadata.getOrigin() != null && !keyMetadata.getOrigin().equals(this.getOrigin())) {
            return false;
        }
        if (keyMetadata.getCustomKeyStoreId() == null ^ this.getCustomKeyStoreId() == null) {
            return false;
        }
        if (keyMetadata.getCustomKeyStoreId() != null && !keyMetadata.getCustomKeyStoreId().equals(this.getCustomKeyStoreId())) {
            return false;
        }
        if (keyMetadata.getCloudHsmClusterId() == null ^ this.getCloudHsmClusterId() == null) {
            return false;
        }
        if (keyMetadata.getCloudHsmClusterId() != null && !keyMetadata.getCloudHsmClusterId().equals(this.getCloudHsmClusterId())) {
            return false;
        }
        if (keyMetadata.getExpirationModel() == null ^ this.getExpirationModel() == null) {
            return false;
        }
        if (keyMetadata.getExpirationModel() != null && !keyMetadata.getExpirationModel().equals(this.getExpirationModel())) {
            return false;
        }
        if (keyMetadata.getKeyManager() == null ^ this.getKeyManager() == null) {
            return false;
        }
        if (keyMetadata.getKeyManager() != null && !keyMetadata.getKeyManager().equals(this.getKeyManager())) {
            return false;
        }
        if (keyMetadata.getCustomerMasterKeySpec() == null ^ this.getCustomerMasterKeySpec() == null) {
            return false;
        }
        if (keyMetadata.getCustomerMasterKeySpec() != null && !keyMetadata.getCustomerMasterKeySpec().equals(this.getCustomerMasterKeySpec())) {
            return false;
        }
        if (keyMetadata.getKeySpec() == null ^ this.getKeySpec() == null) {
            return false;
        }
        if (keyMetadata.getKeySpec() != null && !keyMetadata.getKeySpec().equals(this.getKeySpec())) {
            return false;
        }
        if (keyMetadata.getEncryptionAlgorithms() == null ^ this.getEncryptionAlgorithms() == null) {
            return false;
        }
        if (keyMetadata.getEncryptionAlgorithms() != null && !keyMetadata.getEncryptionAlgorithms().equals(this.getEncryptionAlgorithms())) {
            return false;
        }
        if (keyMetadata.getSigningAlgorithms() == null ^ this.getSigningAlgorithms() == null) {
            return false;
        }
        if (keyMetadata.getSigningAlgorithms() != null && !keyMetadata.getSigningAlgorithms().equals(this.getSigningAlgorithms())) {
            return false;
        }
        if (keyMetadata.getMultiRegion() == null ^ this.getMultiRegion() == null) {
            return false;
        }
        if (keyMetadata.getMultiRegion() != null && !keyMetadata.getMultiRegion().equals(this.getMultiRegion())) {
            return false;
        }
        if (keyMetadata.getMultiRegionConfiguration() == null ^ this.getMultiRegionConfiguration() == null) {
            return false;
        }
        if (keyMetadata.getMultiRegionConfiguration() != null && !keyMetadata.getMultiRegionConfiguration().equals(this.getMultiRegionConfiguration())) {
            return false;
        }
        if (keyMetadata.getPendingDeletionWindowInDays() == null ^ this.getPendingDeletionWindowInDays() == null) {
            return false;
        }
        if (keyMetadata.getPendingDeletionWindowInDays() != null && !keyMetadata.getPendingDeletionWindowInDays().equals(this.getPendingDeletionWindowInDays())) {
            return false;
        }
        if (keyMetadata.getMacAlgorithms() == null ^ this.getMacAlgorithms() == null) {
            return false;
        }
        return keyMetadata.getMacAlgorithms() == null || keyMetadata.getMacAlgorithms().equals(this.getMacAlgorithms());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getAWSAccountId() == null ? 0 : this.getAWSAccountId().hashCode());
        n2 = 31 * n2 + (this.getKeyId() == null ? 0 : this.getKeyId().hashCode());
        n2 = 31 * n2 + (this.getArn() == null ? 0 : this.getArn().hashCode());
        n2 = 31 * n2 + (this.getCreationDate() == null ? 0 : this.getCreationDate().hashCode());
        n2 = 31 * n2 + (this.getEnabled() == null ? 0 : this.getEnabled().hashCode());
        n2 = 31 * n2 + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        n2 = 31 * n2 + (this.getKeyUsage() == null ? 0 : this.getKeyUsage().hashCode());
        n2 = 31 * n2 + (this.getKeyState() == null ? 0 : this.getKeyState().hashCode());
        n2 = 31 * n2 + (this.getDeletionDate() == null ? 0 : this.getDeletionDate().hashCode());
        n2 = 31 * n2 + (this.getValidTo() == null ? 0 : this.getValidTo().hashCode());
        n2 = 31 * n2 + (this.getOrigin() == null ? 0 : this.getOrigin().hashCode());
        n2 = 31 * n2 + (this.getCustomKeyStoreId() == null ? 0 : this.getCustomKeyStoreId().hashCode());
        n2 = 31 * n2 + (this.getCloudHsmClusterId() == null ? 0 : this.getCloudHsmClusterId().hashCode());
        n2 = 31 * n2 + (this.getExpirationModel() == null ? 0 : this.getExpirationModel().hashCode());
        n2 = 31 * n2 + (this.getKeyManager() == null ? 0 : this.getKeyManager().hashCode());
        n2 = 31 * n2 + (this.getCustomerMasterKeySpec() == null ? 0 : this.getCustomerMasterKeySpec().hashCode());
        n2 = 31 * n2 + (this.getKeySpec() == null ? 0 : this.getKeySpec().hashCode());
        n2 = 31 * n2 + (this.getEncryptionAlgorithms() == null ? 0 : this.getEncryptionAlgorithms().hashCode());
        n2 = 31 * n2 + (this.getSigningAlgorithms() == null ? 0 : this.getSigningAlgorithms().hashCode());
        n2 = 31 * n2 + (this.getMultiRegion() == null ? 0 : this.getMultiRegion().hashCode());
        n2 = 31 * n2 + (this.getMultiRegionConfiguration() == null ? 0 : this.getMultiRegionConfiguration().hashCode());
        n2 = 31 * n2 + (this.getPendingDeletionWindowInDays() == null ? 0 : this.getPendingDeletionWindowInDays().hashCode());
        n2 = 31 * n2 + (this.getMacAlgorithms() == null ? 0 : this.getMacAlgorithms().hashCode());
        return n2;
    }

    public KeyMetadata clone() {
        try {
            return (KeyMetadata)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", cloneNotSupportedException);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KeyMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

