/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.kms.model.EncryptionAlgorithmSpec;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class EncryptResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private ByteBuffer ciphertextBlob;
    private String keyId;
    private String encryptionAlgorithm;

    public void setCiphertextBlob(ByteBuffer byteBuffer) {
        this.ciphertextBlob = byteBuffer;
    }

    public ByteBuffer getCiphertextBlob() {
        return this.ciphertextBlob;
    }

    public EncryptResult withCiphertextBlob(ByteBuffer byteBuffer) {
        this.setCiphertextBlob(byteBuffer);
        return this;
    }

    public void setKeyId(String string) {
        this.keyId = string;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public EncryptResult withKeyId(String string) {
        this.setKeyId(string);
        return this;
    }

    public void setEncryptionAlgorithm(String string) {
        this.encryptionAlgorithm = string;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public EncryptResult withEncryptionAlgorithm(String string) {
        this.setEncryptionAlgorithm(string);
        return this;
    }

    public EncryptResult withEncryptionAlgorithm(EncryptionAlgorithmSpec encryptionAlgorithmSpec) {
        this.encryptionAlgorithm = encryptionAlgorithmSpec.toString();
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getCiphertextBlob() != null) {
            stringBuilder.append("CiphertextBlob: ").append(this.getCiphertextBlob()).append(",");
        }
        if (this.getKeyId() != null) {
            stringBuilder.append("KeyId: ").append(this.getKeyId()).append(",");
        }
        if (this.getEncryptionAlgorithm() != null) {
            stringBuilder.append("EncryptionAlgorithm: ").append(this.getEncryptionAlgorithm());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof EncryptResult)) {
            return false;
        }
        EncryptResult encryptResult = (EncryptResult)object;
        if (encryptResult.getCiphertextBlob() == null ^ this.getCiphertextBlob() == null) {
            return false;
        }
        if (encryptResult.getCiphertextBlob() != null && !encryptResult.getCiphertextBlob().equals(this.getCiphertextBlob())) {
            return false;
        }
        if (encryptResult.getKeyId() == null ^ this.getKeyId() == null) {
            return false;
        }
        if (encryptResult.getKeyId() != null && !encryptResult.getKeyId().equals(this.getKeyId())) {
            return false;
        }
        if (encryptResult.getEncryptionAlgorithm() == null ^ this.getEncryptionAlgorithm() == null) {
            return false;
        }
        return encryptResult.getEncryptionAlgorithm() == null || encryptResult.getEncryptionAlgorithm().equals(this.getEncryptionAlgorithm());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getCiphertextBlob() == null ? 0 : this.getCiphertextBlob().hashCode());
        n2 = 31 * n2 + (this.getKeyId() == null ? 0 : this.getKeyId().hashCode());
        n2 = 31 * n2 + (this.getEncryptionAlgorithm() == null ? 0 : this.getEncryptionAlgorithm().hashCode());
        return n2;
    }

    public EncryptResult clone() {
        try {
            return (EncryptResult)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", cloneNotSupportedException);
        }
    }
}

