/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.kms.model.EncryptionAlgorithmSpec;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class EncryptRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String keyId;
    private ByteBuffer plaintext;
    private SdkInternalMap<String, String> encryptionContext;
    private SdkInternalList<String> grantTokens;
    private String encryptionAlgorithm;

    public void setKeyId(String string) {
        this.keyId = string;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public EncryptRequest withKeyId(String string) {
        this.setKeyId(string);
        return this;
    }

    public void setPlaintext(ByteBuffer byteBuffer) {
        this.plaintext = byteBuffer;
    }

    public ByteBuffer getPlaintext() {
        return this.plaintext;
    }

    public EncryptRequest withPlaintext(ByteBuffer byteBuffer) {
        this.setPlaintext(byteBuffer);
        return this;
    }

    public Map<String, String> getEncryptionContext() {
        if (this.encryptionContext == null) {
            this.encryptionContext = new SdkInternalMap();
        }
        return this.encryptionContext;
    }

    public void setEncryptionContext(Map<String, String> map) {
        this.encryptionContext = map == null ? null : new SdkInternalMap<String, String>(map);
    }

    public EncryptRequest withEncryptionContext(Map<String, String> map) {
        this.setEncryptionContext(map);
        return this;
    }

    public EncryptRequest addEncryptionContextEntry(String string, String string2) {
        if (null == this.encryptionContext) {
            this.encryptionContext = new SdkInternalMap();
        }
        if (this.encryptionContext.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.encryptionContext.put(string, string2);
        return this;
    }

    public EncryptRequest clearEncryptionContextEntries() {
        this.encryptionContext = null;
        return this;
    }

    public List<String> getGrantTokens() {
        if (this.grantTokens == null) {
            this.grantTokens = new SdkInternalList();
        }
        return this.grantTokens;
    }

    public void setGrantTokens(Collection<String> collection) {
        if (collection == null) {
            this.grantTokens = null;
            return;
        }
        this.grantTokens = new SdkInternalList<String>(collection);
    }

    public EncryptRequest withGrantTokens(String ... stringArray) {
        if (this.grantTokens == null) {
            this.setGrantTokens(new SdkInternalList<String>(stringArray.length));
        }
        for (String string : stringArray) {
            this.grantTokens.add(string);
        }
        return this;
    }

    public EncryptRequest withGrantTokens(Collection<String> collection) {
        this.setGrantTokens(collection);
        return this;
    }

    public void setEncryptionAlgorithm(String string) {
        this.encryptionAlgorithm = string;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public EncryptRequest withEncryptionAlgorithm(String string) {
        this.setEncryptionAlgorithm(string);
        return this;
    }

    public EncryptRequest withEncryptionAlgorithm(EncryptionAlgorithmSpec encryptionAlgorithmSpec) {
        this.encryptionAlgorithm = encryptionAlgorithmSpec.toString();
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getKeyId() != null) {
            stringBuilder.append("KeyId: ").append(this.getKeyId()).append(",");
        }
        if (this.getPlaintext() != null) {
            stringBuilder.append("Plaintext: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getEncryptionContext() != null) {
            stringBuilder.append("EncryptionContext: ").append(this.getEncryptionContext()).append(",");
        }
        if (this.getGrantTokens() != null) {
            stringBuilder.append("GrantTokens: ").append(this.getGrantTokens()).append(",");
        }
        if (this.getEncryptionAlgorithm() != null) {
            stringBuilder.append("EncryptionAlgorithm: ").append(this.getEncryptionAlgorithm());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof EncryptRequest)) {
            return false;
        }
        EncryptRequest encryptRequest = (EncryptRequest)object;
        if (encryptRequest.getKeyId() == null ^ this.getKeyId() == null) {
            return false;
        }
        if (encryptRequest.getKeyId() != null && !encryptRequest.getKeyId().equals(this.getKeyId())) {
            return false;
        }
        if (encryptRequest.getPlaintext() == null ^ this.getPlaintext() == null) {
            return false;
        }
        if (encryptRequest.getPlaintext() != null && !encryptRequest.getPlaintext().equals(this.getPlaintext())) {
            return false;
        }
        if (encryptRequest.getEncryptionContext() == null ^ this.getEncryptionContext() == null) {
            return false;
        }
        if (encryptRequest.getEncryptionContext() != null && !encryptRequest.getEncryptionContext().equals(this.getEncryptionContext())) {
            return false;
        }
        if (encryptRequest.getGrantTokens() == null ^ this.getGrantTokens() == null) {
            return false;
        }
        if (encryptRequest.getGrantTokens() != null && !encryptRequest.getGrantTokens().equals(this.getGrantTokens())) {
            return false;
        }
        if (encryptRequest.getEncryptionAlgorithm() == null ^ this.getEncryptionAlgorithm() == null) {
            return false;
        }
        return encryptRequest.getEncryptionAlgorithm() == null || encryptRequest.getEncryptionAlgorithm().equals(this.getEncryptionAlgorithm());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getKeyId() == null ? 0 : this.getKeyId().hashCode());
        n2 = 31 * n2 + (this.getPlaintext() == null ? 0 : this.getPlaintext().hashCode());
        n2 = 31 * n2 + (this.getEncryptionContext() == null ? 0 : this.getEncryptionContext().hashCode());
        n2 = 31 * n2 + (this.getGrantTokens() == null ? 0 : this.getGrantTokens().hashCode());
        n2 = 31 * n2 + (this.getEncryptionAlgorithm() == null ? 0 : this.getEncryptionAlgorithm().hashCode());
        return n2;
    }

    @Override
    public EncryptRequest clone() {
        return (EncryptRequest)super.clone();
    }
}

