/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.kms.model.CustomerMasterKeySpec;
import com.amazonaws.services.kms.model.KeySpec;
import com.amazonaws.services.kms.model.KeyUsageType;
import com.amazonaws.services.kms.model.OriginType;
import com.amazonaws.services.kms.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateKeyRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String policy;
    private String description;
    private String keyUsage;
    @Deprecated
    private String customerMasterKeySpec;
    private String keySpec;
    private String origin;
    private String customKeyStoreId;
    private Boolean bypassPolicyLockoutSafetyCheck;
    private SdkInternalList<Tag> tags;
    private Boolean multiRegion;

    public void setPolicy(String string) {
        this.policy = string;
    }

    public String getPolicy() {
        return this.policy;
    }

    public CreateKeyRequest withPolicy(String string) {
        this.setPolicy(string);
        return this;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateKeyRequest withDescription(String string) {
        this.setDescription(string);
        return this;
    }

    public void setKeyUsage(String string) {
        this.keyUsage = string;
    }

    public String getKeyUsage() {
        return this.keyUsage;
    }

    public CreateKeyRequest withKeyUsage(String string) {
        this.setKeyUsage(string);
        return this;
    }

    public void setKeyUsage(KeyUsageType keyUsageType) {
        this.withKeyUsage(keyUsageType);
    }

    public CreateKeyRequest withKeyUsage(KeyUsageType keyUsageType) {
        this.keyUsage = keyUsageType.toString();
        return this;
    }

    @Deprecated
    public void setCustomerMasterKeySpec(String string) {
        this.customerMasterKeySpec = string;
    }

    @Deprecated
    public String getCustomerMasterKeySpec() {
        return this.customerMasterKeySpec;
    }

    @Deprecated
    public CreateKeyRequest withCustomerMasterKeySpec(String string) {
        this.setCustomerMasterKeySpec(string);
        return this;
    }

    @Deprecated
    public void setCustomerMasterKeySpec(CustomerMasterKeySpec customerMasterKeySpec) {
        this.withCustomerMasterKeySpec(customerMasterKeySpec);
    }

    @Deprecated
    public CreateKeyRequest withCustomerMasterKeySpec(CustomerMasterKeySpec customerMasterKeySpec) {
        this.customerMasterKeySpec = customerMasterKeySpec.toString();
        return this;
    }

    public void setKeySpec(String string) {
        this.keySpec = string;
    }

    public String getKeySpec() {
        return this.keySpec;
    }

    public CreateKeyRequest withKeySpec(String string) {
        this.setKeySpec(string);
        return this;
    }

    public void setKeySpec(KeySpec keySpec) {
        this.withKeySpec(keySpec);
    }

    public CreateKeyRequest withKeySpec(KeySpec keySpec) {
        this.keySpec = keySpec.toString();
        return this;
    }

    public void setOrigin(String string) {
        this.origin = string;
    }

    public String getOrigin() {
        return this.origin;
    }

    public CreateKeyRequest withOrigin(String string) {
        this.setOrigin(string);
        return this;
    }

    public void setOrigin(OriginType originType) {
        this.withOrigin(originType);
    }

    public CreateKeyRequest withOrigin(OriginType originType) {
        this.origin = originType.toString();
        return this;
    }

    public void setCustomKeyStoreId(String string) {
        this.customKeyStoreId = string;
    }

    public String getCustomKeyStoreId() {
        return this.customKeyStoreId;
    }

    public CreateKeyRequest withCustomKeyStoreId(String string) {
        this.setCustomKeyStoreId(string);
        return this;
    }

    public void setBypassPolicyLockoutSafetyCheck(Boolean bl) {
        this.bypassPolicyLockoutSafetyCheck = bl;
    }

    public Boolean getBypassPolicyLockoutSafetyCheck() {
        return this.bypassPolicyLockoutSafetyCheck;
    }

    public CreateKeyRequest withBypassPolicyLockoutSafetyCheck(Boolean bl) {
        this.setBypassPolicyLockoutSafetyCheck(bl);
        return this;
    }

    public Boolean isBypassPolicyLockoutSafetyCheck() {
        return this.bypassPolicyLockoutSafetyCheck;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> collection) {
        if (collection == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(collection);
    }

    public CreateKeyRequest withTags(Tag ... tagArray) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tagArray.length));
        }
        for (Tag tag : tagArray) {
            this.tags.add(tag);
        }
        return this;
    }

    public CreateKeyRequest withTags(Collection<Tag> collection) {
        this.setTags(collection);
        return this;
    }

    public void setMultiRegion(Boolean bl) {
        this.multiRegion = bl;
    }

    public Boolean getMultiRegion() {
        return this.multiRegion;
    }

    public CreateKeyRequest withMultiRegion(Boolean bl) {
        this.setMultiRegion(bl);
        return this;
    }

    public Boolean isMultiRegion() {
        return this.multiRegion;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getPolicy() != null) {
            stringBuilder.append("Policy: ").append(this.getPolicy()).append(",");
        }
        if (this.getDescription() != null) {
            stringBuilder.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getKeyUsage() != null) {
            stringBuilder.append("KeyUsage: ").append(this.getKeyUsage()).append(",");
        }
        if (this.getCustomerMasterKeySpec() != null) {
            stringBuilder.append("CustomerMasterKeySpec: ").append(this.getCustomerMasterKeySpec()).append(",");
        }
        if (this.getKeySpec() != null) {
            stringBuilder.append("KeySpec: ").append(this.getKeySpec()).append(",");
        }
        if (this.getOrigin() != null) {
            stringBuilder.append("Origin: ").append(this.getOrigin()).append(",");
        }
        if (this.getCustomKeyStoreId() != null) {
            stringBuilder.append("CustomKeyStoreId: ").append(this.getCustomKeyStoreId()).append(",");
        }
        if (this.getBypassPolicyLockoutSafetyCheck() != null) {
            stringBuilder.append("BypassPolicyLockoutSafetyCheck: ").append(this.getBypassPolicyLockoutSafetyCheck()).append(",");
        }
        if (this.getTags() != null) {
            stringBuilder.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getMultiRegion() != null) {
            stringBuilder.append("MultiRegion: ").append(this.getMultiRegion());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof CreateKeyRequest)) {
            return false;
        }
        CreateKeyRequest createKeyRequest = (CreateKeyRequest)object;
        if (createKeyRequest.getPolicy() == null ^ this.getPolicy() == null) {
            return false;
        }
        if (createKeyRequest.getPolicy() != null && !createKeyRequest.getPolicy().equals(this.getPolicy())) {
            return false;
        }
        if (createKeyRequest.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (createKeyRequest.getDescription() != null && !createKeyRequest.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (createKeyRequest.getKeyUsage() == null ^ this.getKeyUsage() == null) {
            return false;
        }
        if (createKeyRequest.getKeyUsage() != null && !createKeyRequest.getKeyUsage().equals(this.getKeyUsage())) {
            return false;
        }
        if (createKeyRequest.getCustomerMasterKeySpec() == null ^ this.getCustomerMasterKeySpec() == null) {
            return false;
        }
        if (createKeyRequest.getCustomerMasterKeySpec() != null && !createKeyRequest.getCustomerMasterKeySpec().equals(this.getCustomerMasterKeySpec())) {
            return false;
        }
        if (createKeyRequest.getKeySpec() == null ^ this.getKeySpec() == null) {
            return false;
        }
        if (createKeyRequest.getKeySpec() != null && !createKeyRequest.getKeySpec().equals(this.getKeySpec())) {
            return false;
        }
        if (createKeyRequest.getOrigin() == null ^ this.getOrigin() == null) {
            return false;
        }
        if (createKeyRequest.getOrigin() != null && !createKeyRequest.getOrigin().equals(this.getOrigin())) {
            return false;
        }
        if (createKeyRequest.getCustomKeyStoreId() == null ^ this.getCustomKeyStoreId() == null) {
            return false;
        }
        if (createKeyRequest.getCustomKeyStoreId() != null && !createKeyRequest.getCustomKeyStoreId().equals(this.getCustomKeyStoreId())) {
            return false;
        }
        if (createKeyRequest.getBypassPolicyLockoutSafetyCheck() == null ^ this.getBypassPolicyLockoutSafetyCheck() == null) {
            return false;
        }
        if (createKeyRequest.getBypassPolicyLockoutSafetyCheck() != null && !createKeyRequest.getBypassPolicyLockoutSafetyCheck().equals(this.getBypassPolicyLockoutSafetyCheck())) {
            return false;
        }
        if (createKeyRequest.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (createKeyRequest.getTags() != null && !createKeyRequest.getTags().equals(this.getTags())) {
            return false;
        }
        if (createKeyRequest.getMultiRegion() == null ^ this.getMultiRegion() == null) {
            return false;
        }
        return createKeyRequest.getMultiRegion() == null || createKeyRequest.getMultiRegion().equals(this.getMultiRegion());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getPolicy() == null ? 0 : this.getPolicy().hashCode());
        n2 = 31 * n2 + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        n2 = 31 * n2 + (this.getKeyUsage() == null ? 0 : this.getKeyUsage().hashCode());
        n2 = 31 * n2 + (this.getCustomerMasterKeySpec() == null ? 0 : this.getCustomerMasterKeySpec().hashCode());
        n2 = 31 * n2 + (this.getKeySpec() == null ? 0 : this.getKeySpec().hashCode());
        n2 = 31 * n2 + (this.getOrigin() == null ? 0 : this.getOrigin().hashCode());
        n2 = 31 * n2 + (this.getCustomKeyStoreId() == null ? 0 : this.getCustomKeyStoreId().hashCode());
        n2 = 31 * n2 + (this.getBypassPolicyLockoutSafetyCheck() == null ? 0 : this.getBypassPolicyLockoutSafetyCheck().hashCode());
        n2 = 31 * n2 + (this.getTags() == null ? 0 : this.getTags().hashCode());
        n2 = 31 * n2 + (this.getMultiRegion() == null ? 0 : this.getMultiRegion().hashCode());
        return n2;
    }

    @Override
    public CreateKeyRequest clone() {
        return (CreateKeyRequest)super.clone();
    }
}

