/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.retry.v2;

import com.amazonaws.retry.v2.RetryCondition;
import com.amazonaws.retry.v2.RetryPolicyContext;
import com.amazonaws.util.ValidationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RetryOnStatusCodeCondition
implements RetryCondition {
    private final List<Integer> statusCodesToRetryOn;

    public RetryOnStatusCodeCondition(List<Integer> list) {
        this.statusCodesToRetryOn = new ArrayList<Integer>((Collection)ValidationUtils.assertNotNull(list, "statusCodesToRetryOn"));
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext retryPolicyContext) {
        if (retryPolicyContext.httpStatusCode() != null) {
            for (Integer n : this.statusCodesToRetryOn) {
                if (!n.equals(retryPolicyContext.httpStatusCode())) continue;
                return true;
            }
        }
        return false;
    }
}

