/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.retry;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.retry.RetryMode;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.retry.internal.MaxAttemptsResolver;
import com.amazonaws.retry.v2.RetryPolicy;
import com.amazonaws.retry.v2.RetryPolicyContext;
import com.amazonaws.util.ValidationUtils;

@SdkInternalApi
public class RetryPolicyAdapter
implements RetryPolicy {
    private final com.amazonaws.retry.RetryPolicy legacyRetryPolicy;
    private final ClientConfiguration clientConfiguration;
    private final int maxErrorRetry;
    private final RetryPolicy.BackoffStrategy backoffStrategy;

    public RetryPolicyAdapter(com.amazonaws.retry.RetryPolicy retryPolicy, ClientConfiguration clientConfiguration) {
        this.legacyRetryPolicy = ValidationUtils.assertNotNull(retryPolicy, "legacyRetryPolicy");
        this.clientConfiguration = ValidationUtils.assertNotNull(clientConfiguration, "clientConfiguration");
        this.maxErrorRetry = this.resolveMaxErrorRetry();
        this.backoffStrategy = this.resolveBackoffStrategy();
    }

    @Override
    public long computeDelayBeforeNextRetry(RetryPolicyContext retryPolicyContext) {
        return this.backoffStrategy.delayBeforeNextRetry((AmazonWebServiceRequest)retryPolicyContext.originalRequest(), (AmazonClientException)retryPolicyContext.exception(), retryPolicyContext.retriesAttempted());
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext retryPolicyContext) {
        return !this.maxRetriesExceeded(retryPolicyContext) && this.isRetryable(retryPolicyContext);
    }

    public boolean isRetryable(RetryPolicyContext retryPolicyContext) {
        return this.legacyRetryPolicy.getRetryCondition().shouldRetry((AmazonWebServiceRequest)retryPolicyContext.originalRequest(), (AmazonClientException)retryPolicyContext.exception(), retryPolicyContext.retriesAttempted());
    }

    public com.amazonaws.retry.RetryPolicy getLegacyRetryPolicy() {
        return this.legacyRetryPolicy;
    }

    private RetryPolicy.BackoffStrategy resolveBackoffStrategy() {
        if (this.legacyRetryPolicy.isBackoffStrategyInRetryModeHonored()) {
            return this.backoffStrategyByRetryMode();
        }
        return this.legacyRetryPolicy.getBackoffStrategy();
    }

    private RetryPolicy.BackoffStrategy backoffStrategyByRetryMode() {
        RetryMode retryMode = this.clientConfiguration.getRetryMode() == null ? this.legacyRetryPolicy.getRetryMode() : this.clientConfiguration.getRetryMode();
        return PredefinedRetryPolicies.getDefaultBackoffStrategy(retryMode);
    }

    private int resolveMaxErrorRetry() {
        if (this.legacyRetryPolicy.isMaxErrorRetryInClientConfigHonored() && this.clientConfiguration.getMaxErrorRetry() >= 0) {
            return this.clientConfiguration.getMaxErrorRetry();
        }
        Integer n = new MaxAttemptsResolver().maxAttempts();
        if (n != null) {
            return n - 1;
        }
        if (this.shouldUseStandardModeDefaultMaxRetry()) {
            return 2;
        }
        return this.legacyRetryPolicy.getMaxErrorRetry();
    }

    private boolean shouldUseStandardModeDefaultMaxRetry() {
        RetryMode retryMode = this.clientConfiguration.getRetryMode() == null ? this.legacyRetryPolicy.getRetryMode() : this.clientConfiguration.getRetryMode();
        return (retryMode.equals((Object)RetryMode.STANDARD) || retryMode.equals((Object)RetryMode.ADAPTIVE)) && this.legacyRetryPolicy.isDefaultMaxErrorRetryInRetryModeHonored();
    }

    public boolean maxRetriesExceeded(RetryPolicyContext retryPolicyContext) {
        return retryPolicyContext.retriesAttempted() >= this.maxErrorRetry;
    }

    public int getMaxErrorRetry() {
        return this.maxErrorRetry;
    }

    public RetryPolicy.BackoffStrategy getBackoffStrategy() {
        return this.backoffStrategy;
    }
}

