/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.regions;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.SdkClientException;
import com.amazonaws.regions.LegacyRegionXmlLoadUtils;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionMetadata;
import com.amazonaws.regions.RegionMetadataFactory;
import com.amazonaws.util.SdkHttpUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;

public class RegionUtils {
    private static volatile RegionMetadata regionMetadata;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegionMetadata getRegionMetadata() {
        RegionMetadata regionMetadata = RegionUtils.regionMetadata;
        if (regionMetadata != null) {
            return regionMetadata;
        }
        Class<RegionUtils> clazz = RegionUtils.class;
        synchronized (RegionUtils.class) {
            if (RegionUtils.regionMetadata == null) {
                RegionUtils.initialize();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return RegionUtils.regionMetadata;
        }
    }

    public static void initialize() {
        regionMetadata = RegionMetadataFactory.create();
    }

    public static void initializeWithMetadata(RegionMetadata regionMetadata) {
        if (regionMetadata == null) {
            throw new IllegalArgumentException("metadata cannot be null");
        }
        RegionUtils.regionMetadata = regionMetadata;
    }

    public static List<Region> getRegions() {
        return RegionUtils.getRegionMetadata().getRegions();
    }

    public static List<Region> getRegionsForService(String string) {
        return RegionUtils.getRegionMetadata().getRegionsForService(string);
    }

    public static Region getRegion(String string) {
        String string2 = string == null ? null : SdkHttpUtils.urlEncode(string, false);
        return RegionUtils.getRegionMetadata().getRegion(string2);
    }

    @Deprecated
    public static RegionMetadata loadMetadataFromURI(URI uRI) throws IOException {
        return RegionUtils.loadMetadataFromURI(uRI, null);
    }

    @Deprecated
    public static RegionMetadata loadMetadataFromURI(URI uRI, ClientConfiguration clientConfiguration) throws IOException {
        return LegacyRegionXmlLoadUtils.load(uRI, clientConfiguration);
    }

    @Deprecated
    public static RegionMetadata loadMetadataFromFile(File file) throws IOException {
        return LegacyRegionXmlLoadUtils.load(file);
    }

    @Deprecated
    public static RegionMetadata loadMetadataFromResource(String string) throws IOException {
        return LegacyRegionXmlLoadUtils.load(RegionUtils.class, string);
    }

    @Deprecated
    public static RegionMetadata loadMetadataFromResource(Class<?> clazz, String string) throws IOException {
        return LegacyRegionXmlLoadUtils.load(clazz, string);
    }

    @Deprecated
    public static RegionMetadata loadMetadataFromResource(ClassLoader classLoader, String string) throws IOException {
        return LegacyRegionXmlLoadUtils.load(classLoader, string);
    }

    @Deprecated
    public static RegionMetadata loadMetadataFromInputStream(InputStream inputStream2) throws IOException {
        return LegacyRegionXmlLoadUtils.load(inputStream2);
    }

    @Deprecated
    public static void init() {
        RegionUtils.initialize();
    }

    @Deprecated
    public static synchronized void initializeFromURI(URI uRI) {
        RegionUtils.initializeFromURI(uRI, null);
    }

    @Deprecated
    public static synchronized void initializeFromURI(URI uRI, ClientConfiguration clientConfiguration) {
        try {
            regionMetadata = RegionUtils.loadMetadataFromURI(uRI, clientConfiguration);
        }
        catch (IOException iOException) {
            throw new SdkClientException("Error parsing region metadata from " + uRI, iOException);
        }
    }

    @Deprecated
    public static synchronized void initializeFromFile(File file) {
        try {
            regionMetadata = RegionUtils.loadMetadataFromFile(file);
        }
        catch (IOException iOException) {
            throw new SdkClientException("Error parsing region metadata from " + file, iOException);
        }
    }

    @Deprecated
    public static synchronized void initializeFromResource(String string) {
        RegionUtils.initializeFromResource(RegionUtils.class, string);
    }

    @Deprecated
    public static synchronized void initializeFromResource(Class<?> clazz, String string) {
        try {
            regionMetadata = RegionUtils.loadMetadataFromResource(clazz, string);
        }
        catch (IOException iOException) {
            throw new SdkClientException("Error parsing region metadata from resource " + string, iOException);
        }
    }

    @Deprecated
    public static synchronized void initializeFromResource(ClassLoader classLoader, String string) {
        try {
            regionMetadata = RegionUtils.loadMetadataFromResource(classLoader, string);
        }
        catch (IOException iOException) {
            throw new SdkClientException("Error parsing region metadata from resource " + string, iOException);
        }
    }
}

