/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.regions;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.regions.AbstractRegionMetadataProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.util.ValidationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

@SdkInternalApi
public class InMemoryRegionsProvider
extends AbstractRegionMetadataProvider {
    private final List<Region> regions;

    public InMemoryRegionsProvider(List<Region> list) {
        ValidationUtils.assertNotNull(list, "regions");
        this.regions = Collections.unmodifiableList(new ArrayList<Region>(list));
    }

    @Override
    public List<Region> getRegions() {
        return Collections.unmodifiableList(new ArrayList<Region>(this.regions));
    }

    @Override
    public Region getRegion(String string) {
        for (Region region : this.regions) {
            if (!region.getName().equals(string)) continue;
            return region;
        }
        return null;
    }

    @Override
    public List<Region> getRegionsForService(String string) {
        LinkedList<Region> linkedList = new LinkedList<Region>();
        for (Region region : this.regions) {
            if (!region.isServiceSupported(string)) continue;
            linkedList.add(region);
        }
        return linkedList;
    }

    @Override
    public Region tryGetRegionByExplicitEndpoint(String string) {
        return null;
    }

    @Override
    public Region tryGetRegionByEndpointDnsSuffix(String string) {
        return null;
    }

    public String toString() {
        return this.regions.toString();
    }
}

